/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class IgniteInternalCheckedException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final String groupName;
    private final int code;
    private final UUID traceId;

    public IgniteInternalCheckedException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteInternalCheckedException(UUID traceId, int code) {
        super(ErrorGroup.errorMessage(traceId, code, null));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalCheckedException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteInternalCheckedException(UUID traceId, int code, String message) {
        super(ErrorGroup.errorMessage(traceId, code, message));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalCheckedException(int code, Throwable cause) {
        this(UUID.randomUUID(), code, cause);
    }

    public IgniteInternalCheckedException(UUID traceId, int code, Throwable cause) {
        super(ErrorGroup.errorMessageFromCause(traceId, code, cause), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalCheckedException(int code, String message, Throwable cause) {
        this(UUID.randomUUID(), code, message, cause);
    }

    public IgniteInternalCheckedException(UUID traceId, int code, String message, Throwable cause) {
        super(ErrorGroup.errorMessage(traceId, code, message), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalCheckedException(UUID traceId, int code, String message, @Nullable Throwable cause, boolean writableStackTrace) {
        super(ErrorGroup.errorMessage(traceId, code, message), cause, true, writableStackTrace);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    @Deprecated
    public IgniteInternalCheckedException() {
        this(ErrorGroups.Common.UNKNOWN_ERR);
    }

    @Deprecated
    public IgniteInternalCheckedException(String msg) {
        this(ErrorGroups.Common.UNKNOWN_ERR, msg);
    }

    @Deprecated
    public IgniteInternalCheckedException(Throwable cause) {
        this(ErrorGroups.Common.UNKNOWN_ERR, cause);
    }

    @Deprecated
    public IgniteInternalCheckedException(String msg, @Nullable Throwable cause, boolean writableStackTrace) {
        this(UUID.randomUUID(), ErrorGroups.Common.UNKNOWN_ERR, msg, cause, writableStackTrace);
    }

    @Deprecated
    public IgniteInternalCheckedException(String msg, @Nullable Throwable cause) {
        this(ErrorGroups.Common.UNKNOWN_ERR, msg, cause);
    }

    public String groupName() {
        return this.groupName;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return "IGN-" + this.groupName() + "-" + this.errorCode();
    }

    public int groupCode() {
        return ErrorGroup.extractGroupCode(this.code);
    }

    public int errorCode() {
        return ErrorGroup.extractErrorCode(this.code);
    }

    public UUID traceId() {
        return this.traceId;
    }
}

