/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.sql.ClientAsyncResultSet;
import org.apache.ignite.internal.client.sql.ClientStatement;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.Session;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.sql.reactive.ReactiveResultSet;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientSession
implements Session {
    private final ReliableChannel ch;
    @Nullable
    private final Integer defaultPageSize;
    @Nullable
    private final String defaultSchema;
    @Nullable
    private final Long defaultQueryTimeout;
    @Nullable
    private final Long defaultSessionTimeout;
    @Nullable
    private final Map<String, Object> properties;

    public ClientSession(ReliableChannel ch, @Nullable Integer defaultPageSize, @Nullable String defaultSchema, @Nullable Long defaultQueryTimeout, @Nullable Long defaultSessionTimeout, @Nullable Map<String, Object> properties) {
        this.ch = ch;
        this.defaultPageSize = defaultPageSize;
        this.defaultSchema = defaultSchema;
        this.defaultQueryTimeout = defaultQueryTimeout;
        this.defaultSessionTimeout = defaultSessionTimeout;
        this.properties = properties;
    }

    public CompletableFuture<AsyncResultSet> executeAsync(@Nullable Transaction transaction, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        ClientStatement statement = new ClientStatement(query, null, null, null, null);
        return this.executeAsync(transaction, statement, arguments);
    }

    public CompletableFuture<AsyncResultSet> executeAsync(@Nullable Transaction transaction, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        if (!(statement instanceof ClientStatement)) {
            throw new IllegalArgumentException("Unsupported statement type: " + statement.getClass());
        }
        ClientStatement clientStatement = (ClientStatement)statement;
        return this.ch.serviceAsync(50, w -> {
            ClientTable.writeTx(transaction, w);
            w.out().packString(ClientSession.oneOf(clientStatement.defaultSchema(), this.defaultSchema));
            w.out().packIntNullable(ClientSession.oneOf(clientStatement.pageSizeNullable(), this.defaultPageSize));
            w.out().packLongNullable(ClientSession.oneOf(clientStatement.queryTimeoutNullable(), this.defaultQueryTimeout));
            w.out().packLongNullable(this.defaultSessionTimeout);
            this.packProperties(w, clientStatement.properties());
            w.out().packString(clientStatement.query());
            w.out().packObjectArrayAsBinaryTuple(arguments);
        }, r -> new ClientAsyncResultSet(r.clientChannel(), r.in()));
    }

    public ReactiveResultSet executeReactive(@Nullable Transaction transaction, String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ReactiveResultSet executeReactive(@Nullable Transaction transaction, Statement statement, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long[] executeBatch(@Nullable Transaction transaction, Statement dmlStatement, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Flow.Publisher<Long> executeBatchReactive(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Flow.Publisher<Long> executeBatchReactive(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void executeScript(String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long defaultQueryTimeout(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return this.defaultQueryTimeout == null ? 0L : timeUnit.convert(this.defaultQueryTimeout, TimeUnit.MILLISECONDS);
    }

    public long idleTimeout(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return this.defaultSessionTimeout == null ? 0L : timeUnit.convert(this.defaultSessionTimeout, TimeUnit.MILLISECONDS);
    }

    public String defaultSchema() {
        return this.defaultSchema;
    }

    public int defaultPageSize() {
        return this.defaultPageSize == null ? 0 : this.defaultPageSize;
    }

    @Nullable
    public Object property(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public void close() {
        ClientUtils.sync(this.closeAsync());
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public Flow.Publisher<Void> closeReactive() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Session.SessionBuilder toBuilder() {
        return null;
    }

    private void packProperties(PayloadOutputChannel w, Map<String, Object> props) {
        int size = 0;
        if (props != null) {
            size += props.size();
        }
        if (this.properties != null) {
            if (props != null) {
                for (String k : this.properties.keySet()) {
                    if (props.containsKey(k)) continue;
                    ++size;
                }
            } else {
                size += this.properties.size();
            }
        }
        w.out().packInt(size);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(size * 4, true);
        if (props != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                builder.appendString(entry.getKey());
                ClientBinaryTupleUtils.appendObject((BinaryTupleBuilder)builder, (Object)entry.getValue());
            }
        }
        if (this.properties != null) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                if (props != null && props.containsKey(entry.getKey())) continue;
                builder.appendString(entry.getKey());
                ClientBinaryTupleUtils.appendObject((BinaryTupleBuilder)builder, (Object)entry.getValue());
            }
        }
        w.out().packBinaryTuple(builder);
    }

    private static <T> T oneOf(T a, T b) {
        return a != null ? a : b;
    }
}

