/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcMetaColumnsResult
extends Response {
    private List<JdbcColumnMeta> meta;

    public JdbcMetaColumnsResult() {
    }

    public JdbcMetaColumnsResult(int status, String err) {
        super(status, err);
    }

    public JdbcMetaColumnsResult(Collection<JdbcColumnMeta> meta) {
        Objects.requireNonNull(meta);
        this.meta = new ArrayList<JdbcColumnMeta>(meta);
        this.hasResults = true;
    }

    public List<JdbcColumnMeta> meta() {
        return this.meta;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packArrayHeader(this.meta.size());
        for (JdbcColumnMeta m : this.meta) {
            m.writeBinary(packer);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        int size = unpacker.unpackArrayHeader();
        if (size == 0) {
            this.meta = Collections.emptyList();
            return;
        }
        this.meta = new ArrayList<JdbcColumnMeta>(size);
        for (int i = 0; i < size; ++i) {
            JdbcColumnMeta m = new JdbcColumnMeta();
            m.readBinary(unpacker);
            this.meta.add(m);
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaColumnsResult.class, (Object)this);
    }
}

