/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.mem.unsafe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.mem.DirectMemoryProvider;
import org.apache.ignite.internal.pagememory.mem.DirectMemoryRegion;
import org.apache.ignite.internal.pagememory.mem.MemoryAllocator;
import org.apache.ignite.internal.pagememory.mem.unsafe.UnsafeChunk;
import org.apache.ignite.internal.pagememory.mem.unsafe.UnsafeMemoryAllocator;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public class UnsafeMemoryProvider
implements DirectMemoryProvider {
    private static final IgniteLogger LOG = Loggers.forClass(UnsafeMemoryProvider.class);
    private long[] sizes;
    private List<DirectMemoryRegion> regions;
    private boolean isInit;
    private int used = 0;
    private final MemoryAllocator allocator;

    public UnsafeMemoryProvider(@Nullable MemoryAllocator allocator) {
        this.allocator = allocator == null ? new UnsafeMemoryAllocator() : allocator;
    }

    @Override
    public void initialize(long[] sizes) {
        if (this.isInit) {
            return;
        }
        this.sizes = sizes;
        this.regions = new ArrayList<DirectMemoryRegion>();
        this.isInit = true;
    }

    @Override
    public void shutdown(boolean deallocate) {
        if (!deallocate) {
            this.used = 0;
            return;
        }
        if (this.regions != null) {
            Iterator<DirectMemoryRegion> it = this.regions.iterator();
            while (it.hasNext()) {
                DirectMemoryRegion chunk = it.next();
                this.allocator.freeMemory(chunk.address());
                it.remove();
            }
        }
    }

    @Override
    @Nullable
    public DirectMemoryRegion nextRegion() {
        long ptr;
        if (this.used == this.sizes.length) {
            return null;
        }
        if (this.used < this.regions.size()) {
            return this.regions.get(this.used++);
        }
        long chunkSize = this.sizes[this.regions.size()];
        try {
            ptr = this.allocator.allocateMemory(chunkSize);
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to allocate next memory chunk: " + IgniteUtils.readableSize((long)chunkSize, (boolean)true) + ". Check if chunkSize is too large and 32-bit JVM is used.";
            if (this.regions.isEmpty()) {
                throw new IgniteInternalException(msg, (Throwable)e);
            }
            LOG.debug(msg, new Object[0]);
            return null;
        }
        if (ptr <= 0L) {
            LOG.debug("Failed to allocate next memory chunk [size={}]", new Object[]{IgniteUtils.readableSize((long)chunkSize, (boolean)true)});
            return null;
        }
        UnsafeChunk region = new UnsafeChunk(ptr, chunkSize);
        this.regions.add(region);
        ++this.used;
        return region;
    }
}

