/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.entity.EntryMetaBuilder;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.RaftOutter;

public class EntryMetaImpl
implements RaftOutter.EntryMeta {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2000;
    @IgniteToStringInclude
    private final long checksum;
    @IgniteToStringInclude
    private final long dataLen;
    @IgniteToStringInclude
    private final boolean hasChecksum;
    @IgniteToStringInclude
    private final Collection<String> learnersList;
    @IgniteToStringInclude
    private final Collection<String> oldLearnersList;
    @IgniteToStringInclude
    private final Collection<String> oldPeersList;
    @IgniteToStringInclude
    private final Collection<String> peersList;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private EnumOutter.EntryType type;
    private byte[] typeByteArray;

    private EntryMetaImpl(long checksum, long dataLen, boolean hasChecksum, Collection<String> learnersList, Collection<String> oldLearnersList, Collection<String> oldPeersList, Collection<String> peersList, long term, EnumOutter.EntryType type, byte[] typeByteArray) {
        this.checksum = checksum;
        this.dataLen = dataLen;
        this.hasChecksum = hasChecksum;
        this.learnersList = learnersList;
        this.oldLearnersList = oldLearnersList;
        this.oldPeersList = oldPeersList;
        this.peersList = peersList;
        this.term = term;
        this.type = type;
        this.typeByteArray = typeByteArray;
    }

    @Override
    public long checksum() {
        return this.checksum;
    }

    @Override
    public long dataLen() {
        return this.dataLen;
    }

    @Override
    public boolean hasChecksum() {
        return this.hasChecksum;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    @Override
    public Collection<String> oldLearnersList() {
        return this.oldLearnersList;
    }

    @Override
    public Collection<String> oldPeersList() {
        return this.oldPeersList;
    }

    @Override
    public Collection<String> peersList() {
        return this.peersList;
    }

    @Override
    public long term() {
        return this.term;
    }

    byte[] typeByteArray() {
        return this.typeByteArray;
    }

    @Override
    public EnumOutter.EntryType type() {
        return this.type;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(EntryMetaImpl.class, (Object)this);
    }

    public short messageType() {
        return 2000;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EntryMetaImpl otherMessage = (EntryMetaImpl)other;
        return Objects.equals(this.learnersList, otherMessage.learnersList) && Objects.equals(this.oldLearnersList, otherMessage.oldLearnersList) && Objects.equals(this.oldPeersList, otherMessage.oldPeersList) && Objects.equals(this.peersList, otherMessage.peersList) && Objects.equals((Object)this.type, (Object)otherMessage.type) && this.checksum == otherMessage.checksum && this.dataLen == otherMessage.dataLen && this.hasChecksum == otherMessage.hasChecksum && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.checksum, this.dataLen, this.hasChecksum, this.term, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList, this.type});
        return result;
    }

    public static EntryMetaBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject typeByteArraymo = marshaller.marshal((Object)this.type);
        usedDescriptors.addAll((IntCollection)typeByteArraymo.usedDescriptorIds());
        this.typeByteArray = typeByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.type = (EnumOutter.EntryType)((Object)marshaller.unmarshal(this.typeByteArray, descriptorsObj));
        this.typeByteArray = null;
    }

    private static class Builder
    implements EntryMetaBuilder {
        private long checksum;
        private long dataLen;
        private boolean hasChecksum;
        private Collection<String> learnersList;
        private Collection<String> oldLearnersList;
        private Collection<String> oldPeersList;
        private Collection<String> peersList;
        private long term;
        private EnumOutter.EntryType type;
        private byte[] typeByteArray;

        private Builder() {
        }

        @Override
        public EntryMetaBuilder checksum(long checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public EntryMetaBuilder dataLen(long dataLen) {
            this.dataLen = dataLen;
            return this;
        }

        @Override
        public EntryMetaBuilder hasChecksum(boolean hasChecksum) {
            this.hasChecksum = hasChecksum;
            return this;
        }

        @Override
        public EntryMetaBuilder learnersList(Collection<String> learnersList) {
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public EntryMetaBuilder oldLearnersList(Collection<String> oldLearnersList) {
            this.oldLearnersList = oldLearnersList;
            return this;
        }

        @Override
        public EntryMetaBuilder oldPeersList(Collection<String> oldPeersList) {
            this.oldPeersList = oldPeersList;
            return this;
        }

        @Override
        public EntryMetaBuilder peersList(Collection<String> peersList) {
            this.peersList = peersList;
            return this;
        }

        @Override
        public EntryMetaBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public EntryMetaBuilder type(EnumOutter.EntryType type) {
            this.type = type;
            return this;
        }

        @Override
        public EntryMetaBuilder typeByteArray(byte[] typeByteArray) {
            this.typeByteArray = typeByteArray;
            return this;
        }

        @Override
        public long checksum() {
            return this.checksum;
        }

        @Override
        public long dataLen() {
            return this.dataLen;
        }

        @Override
        public boolean hasChecksum() {
            return this.hasChecksum;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public Collection<String> oldLearnersList() {
            return this.oldLearnersList;
        }

        @Override
        public Collection<String> oldPeersList() {
            return this.oldPeersList;
        }

        @Override
        public Collection<String> peersList() {
            return this.peersList;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public EnumOutter.EntryType type() {
            return this.type;
        }

        @Override
        public byte[] typeByteArray() {
            return this.typeByteArray;
        }

        @Override
        public RaftOutter.EntryMeta build() {
            return new EntryMetaImpl(this.checksum, this.dataLen, this.hasChecksum, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList, this.term, this.type, this.typeByteArray);
        }
    }
}

