/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.ErrorResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class ErrorResponseDeserializer
implements MessageDeserializer<RpcRequests.ErrorResponse> {
    private final ErrorResponseBuilder msg;

    ErrorResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.errorResponse();
    }

    public Class<RpcRequests.ErrorResponse> klass() {
        return RpcRequests.ErrorResponse.class;
    }

    public RpcRequests.ErrorResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.errorCode(reader.readInt("errorCode"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.errorMsg(reader.readString("errorMsg"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.leaderId(reader.readString("leaderId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ErrorResponse.class);
    }
}

