/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Mailbox;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.trait.Destination;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class Outbox<RowT>
extends AbstractNode<RowT>
implements Mailbox<RowT>,
SingleNode<RowT>,
Downstream<RowT> {
    private static final IgniteLogger LOG = Loggers.forClass(Outbox.class);
    private final ExchangeService exchange;
    private final MailboxRegistry registry;
    private final long exchangeId;
    private final long targetFragmentId;
    private final Destination<RowT> dest;
    private final Deque<RowT> inBuf = new ArrayDeque<RowT>(512);
    private final Map<String, Buffer> nodeBuffers = new HashMap<String, Buffer>();
    private int waiting;

    public Outbox(ExecutionContext<RowT> ctx, RelDataType rowType, ExchangeService exchange, MailboxRegistry registry, long exchangeId, long targetFragmentId, Destination<RowT> dest) {
        super(ctx, rowType);
        this.exchange = exchange;
        this.registry = registry;
        this.targetFragmentId = targetFragmentId;
        this.exchangeId = exchangeId;
        this.dest = dest;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    public void onAcknowledge(String nodeId, int batchId) throws Exception {
        assert (this.nodeBuffers.containsKey(nodeId));
        this.checkState();
        this.nodeBuffers.get(nodeId).acknowledge(batchId);
    }

    public void init() {
        try {
            this.checkState();
            this.flush();
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    @Override
    public void request(int rowCnt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.inBuf.add(row);
        this.flush();
    }

    @Override
    public void end() throws Exception {
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.flush();
    }

    @Override
    public void onError(Throwable e) {
        try {
            this.sendError(e);
        }
        catch (IgniteInternalCheckedException ex) {
            LOG.info("Unable to send error message", e);
        }
        finally {
            Commons.closeQuiet(this);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.registry.unregister(this);
        for (String node : this.dest.targets()) {
            this.getOrCreateBuffer(node).close();
        }
    }

    @Override
    public void onRegister(Downstream<RowT> downstream) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private void sendBatch(String nodeId, int batchId, boolean last, List<RowT> rows) throws IgniteInternalCheckedException {
        this.exchange.sendBatch(nodeId, this.queryId(), this.targetFragmentId, this.exchangeId, batchId, last, rows);
    }

    private void sendError(Throwable err) throws IgniteInternalCheckedException {
        this.exchange.sendError(this.context().originatingNodeId(), this.queryId(), this.fragmentId(), err);
    }

    private void sendInboxClose(String nodeId) {
        try {
            this.exchange.closeInbox(nodeId, this.queryId(), this.targetFragmentId, this.exchangeId);
        }
        catch (IgniteInternalCheckedException e) {
            LOG.info("Unable to send cancel message", (Throwable)e);
        }
    }

    private Buffer getOrCreateBuffer(String nodeId) {
        return this.nodeBuffers.computeIfAbsent(nodeId, this::createBuffer);
    }

    private Buffer createBuffer(String nodeId) {
        return new Buffer(nodeId);
    }

    private void flush() throws Exception {
        while (!this.inBuf.isEmpty()) {
            this.checkState();
            Collection buffers = this.dest.targets(this.inBuf.peek()).stream().map(this::getOrCreateBuffer).collect(Collectors.toList());
            assert (!CollectionUtils.nullOrEmpty((Collection)buffers));
            if (!buffers.stream().allMatch(rec$ -> ((Buffer)rec$).ready())) {
                return;
            }
            RowT row = this.inBuf.remove();
            for (Buffer dest : buffers) {
                dest.add(row);
            }
        }
        assert (this.inBuf.isEmpty());
        if (this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        } else if (this.waiting == -1) {
            for (String node : this.dest.targets()) {
                this.getOrCreateBuffer(node).end();
            }
        }
    }

    public void onNodeLeft(String nodeId) {
        if (nodeId.equals(this.context().originatingNodeId())) {
            this.context().execute(this::close, this::onError);
        }
    }

    private final class Buffer {
        private final String nodeId;
        private int hwm = -1;
        private int lwm = -1;
        private List<RowT> curr;

        private Buffer(String nodeId) {
            this.nodeId = nodeId;
            this.curr = new ArrayList(256);
        }

        private boolean ready() {
            if (this.hwm == Integer.MAX_VALUE) {
                return false;
            }
            return this.curr.size() < 256 || this.hwm - this.lwm < 4;
        }

        public void add(RowT row) throws IgniteInternalCheckedException {
            assert (this.ready());
            if (this.curr.size() == 256) {
                Outbox.this.sendBatch(this.nodeId, ++this.hwm, false, this.curr);
                this.curr = new ArrayList(256);
            }
            this.curr.add(row);
        }

        public void end() throws IgniteInternalCheckedException {
            if (this.hwm == Integer.MAX_VALUE) {
                return;
            }
            int batchId = this.hwm + 1;
            this.hwm = Integer.MAX_VALUE;
            List tmp = this.curr;
            this.curr = null;
            Outbox.this.sendBatch(this.nodeId, batchId, true, tmp);
        }

        private void acknowledge(int id) throws Exception {
            if (this.lwm > id) {
                return;
            }
            boolean readyBefore = this.ready();
            this.lwm = id;
            if (!readyBefore && this.ready()) {
                Outbox.this.flush();
            }
        }

        public void close() {
            int currBatchId = this.hwm;
            if (this.hwm == Integer.MAX_VALUE) {
                return;
            }
            this.hwm = Integer.MAX_VALUE;
            this.curr = null;
            if (currBatchId >= 0) {
                Outbox.this.sendInboxClose(this.nodeId);
            }
        }
    }
}

