/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.JoinRequestCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.JoinRequestCommandBuilder;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JoinRequestCommandImpl
implements JoinRequestCommand {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 43;
    @IgniteToStringInclude
    private final ClusterTag clusterTag;
    @IgniteToStringInclude
    private final ClusterNodeMessage node;
    @IgniteToStringInclude
    private final String version;

    private JoinRequestCommandImpl(ClusterTag clusterTag, ClusterNodeMessage node, String version) {
        this.clusterTag = clusterTag;
        this.node = node;
        this.version = version;
    }

    @Override
    public ClusterTag clusterTag() {
        return this.clusterTag;
    }

    @Override
    public ClusterNodeMessage node() {
        return this.node;
    }

    @Override
    public String version() {
        return this.version;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(JoinRequestCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 43;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JoinRequestCommandImpl otherMessage = (JoinRequestCommandImpl)other;
        return Objects.equals(this.clusterTag, otherMessage.clusterTag) && Objects.equals(this.node, otherMessage.node) && Objects.equals(this.version, otherMessage.version);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterTag, this.node, this.version);
        return result;
    }

    public static JoinRequestCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.node != null) {
            this.node.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.unmarshal(marshaller, descriptorsObj);
        }
        if (this.node != null) {
            this.node.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements JoinRequestCommandBuilder {
        private ClusterTag clusterTag;
        private ClusterNodeMessage node;
        private String version;

        private Builder() {
        }

        @Override
        public JoinRequestCommandBuilder clusterTag(ClusterTag clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        @Override
        public JoinRequestCommandBuilder node(ClusterNodeMessage node) {
            this.node = node;
            return this;
        }

        @Override
        public JoinRequestCommandBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ClusterTag clusterTag() {
            return this.clusterTag;
        }

        @Override
        public ClusterNodeMessage node() {
            return this.node;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public JoinRequestCommand build() {
            return new JoinRequestCommandImpl(this.clusterTag, this.node, this.version);
        }
    }
}

