/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractRightMaterializedJoinNode;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.jetbrains.annotations.Nullable;

public abstract class NestedLoopJoinNode<RowT>
extends AbstractRightMaterializedJoinNode<RowT> {
    protected final BiPredicate<RowT, RowT> cond;
    final RowHandler.RowFactory<RowT> outputRowFactory;
    final List<RowT> rightMaterialized = new ArrayList<RowT>(512);

    NestedLoopJoinNode(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory) {
        super(ctx);
        this.cond = cond;
        this.outputRowFactory = outputRowFactory;
    }

    @Override
    protected void rewindInternal() {
        this.rightMaterialized.clear();
        super.rewindInternal();
    }

    @Override
    protected void pushRight(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        --this.waitingRight;
        this.rightMaterialized.add(row);
        if (this.waitingRight == 0) {
            this.waitingRight = 512;
            this.rightSource().request(512);
        }
    }

    public static <RowT> NestedLoopJoinNode<RowT> create(ExecutionContext<RowT> ctx, RelDataType outputRowType, RelDataType leftRowType, RelDataType rightRowType, JoinRelType joinType, BiPredicate<RowT, RowT> cond) {
        RowSchema leftRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)leftRowType));
        RowSchema rightRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rightRowType));
        RowSchema outputSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)outputRowType));
        RowHandler.RowFactory<RowT> outputRowFactory = ctx.rowHandler().factory(outputSchema);
        switch (joinType) {
            case INNER: {
                return new InnerJoin<RowT>(ctx, cond, outputRowFactory);
            }
            case LEFT: {
                RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(rightRowSchema);
                return new LeftJoin<RowT>(ctx, cond, outputRowFactory, rightRowFactory);
            }
            case RIGHT: {
                RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(leftRowSchema);
                return new RightJoin<RowT>(ctx, cond, outputRowFactory, leftRowFactory);
            }
            case FULL: {
                RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(leftRowSchema);
                RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(rightRowSchema);
                return new FullOuterJoin<RowT>(ctx, cond, outputRowFactory, leftRowFactory, rightRowFactory);
            }
            case SEMI: {
                return new SemiJoin<RowT>(ctx, cond, outputRowFactory);
            }
            case ANTI: {
                return new AntiJoin<RowT>(ctx, cond, outputRowFactory);
            }
        }
        throw new IllegalStateException("Join type \"" + String.valueOf(joinType) + "\" is not supported yet");
    }

    private static class InnerJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private int rightIdx;

        private InnerJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory) {
            super(ctx, cond, outputRowFactory);
        }

        @Override
        protected void rewindInternal() {
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            Object row = this.outputRowFactory.concat(this.left, this.rightMaterialized.get(this.rightIdx - 1));
                            this.downstream().push(row);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.rightMaterialized.clear();
                this.downstream().end();
            }
        }
    }

    private static class LeftJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private boolean matched;
        private int rightIdx;

        private LeftJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, outputRowFactory);
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.matched = false;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.matched = false;
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            this.matched = true;
                            Object row = this.outputRowFactory.concat(this.left, this.rightMaterialized.get(this.rightIdx - 1));
                            this.downstream().push(row);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        boolean wasPushed = false;
                        if (!this.matched && this.requested > 0) {
                            --this.requested;
                            wasPushed = true;
                            this.downstream().push(this.outputRowFactory.concat(this.left, this.rightRowFactory.create()));
                        }
                        if (!this.matched && !wasPushed) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.rightMaterialized.clear();
                this.downstream().end();
            }
        }
    }

    private static class RightJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        @Nullable
        private BitSet rightNotMatchedIndexes;
        private int lastPushedInd;
        private int rightIdx;

        private RightJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory, RowHandler.RowFactory<RowT> leftRowFactory) {
            super(ctx, cond, outputRowFactory);
            this.leftRowFactory = leftRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.rightNotMatchedIndexes = null;
            this.lastPushedInd = 0;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                if (this.rightNotMatchedIndexes == null) {
                    this.rightNotMatchedIndexes = new BitSet(this.rightMaterialized.size());
                    this.rightNotMatchedIndexes.set(0, this.rightMaterialized.size());
                }
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            Object right = this.rightMaterialized.get(this.rightIdx++);
                            if (!this.cond.test(this.left, right)) continue;
                            --this.requested;
                            this.rightNotMatchedIndexes.clear(this.rightIdx - 1);
                            Object joined = this.outputRowFactory.concat(this.left, right);
                            this.downstream().push(joined);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingLeft == -1 && this.requested > 0 && this.rightNotMatchedIndexes != null && !this.rightNotMatchedIndexes.isEmpty()) {
                assert (this.lastPushedInd >= 0);
                this.inLoop = true;
                try {
                    this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd);
                    while (true) {
                        this.checkState();
                        if (this.lastPushedInd < 0) {
                            break;
                        }
                        RowT row = this.outputRowFactory.concat(this.leftRowFactory.create(), this.rightMaterialized.get(this.lastPushedInd));
                        this.rightNotMatchedIndexes.clear(this.lastPushedInd);
                        --this.requested;
                        this.downstream().push(row);
                        if (this.lastPushedInd == Integer.MAX_VALUE) break;
                        if (this.requested <= 0) {
                            break;
                        }
                        this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd + 1);
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty() && this.rightNotMatchedIndexes.isEmpty()) {
                this.requested = 0;
                this.rightMaterialized.clear();
                this.downstream().end();
            }
        }
    }

    private static class FullOuterJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private boolean leftMatched;
        @Nullable
        private BitSet rightNotMatchedIndexes;
        private int lastPushedInd;
        private int rightIdx;

        private FullOuterJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, outputRowFactory);
            this.leftRowFactory = leftRowFactory;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.leftMatched = false;
            this.rightNotMatchedIndexes = null;
            this.lastPushedInd = 0;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                if (this.rightNotMatchedIndexes == null) {
                    this.rightNotMatchedIndexes = new BitSet(this.rightMaterialized.size());
                    this.rightNotMatchedIndexes.set(0, this.rightMaterialized.size());
                }
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.leftMatched = false;
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            Object right = this.rightMaterialized.get(this.rightIdx++);
                            if (!this.cond.test(this.left, right)) continue;
                            --this.requested;
                            this.leftMatched = true;
                            this.rightNotMatchedIndexes.clear(this.rightIdx - 1);
                            Object joined = this.outputRowFactory.concat(this.left, right);
                            this.downstream().push(joined);
                        }
                        if (this.rightIdx != this.rightMaterialized.size()) continue;
                        boolean wasPushed = false;
                        if (!this.leftMatched && this.requested > 0) {
                            --this.requested;
                            wasPushed = true;
                            this.downstream().push(this.outputRowFactory.concat(this.left, this.rightRowFactory.create()));
                        }
                        if (!this.leftMatched && !wasPushed) continue;
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingLeft == -1 && this.requested > 0 && this.rightNotMatchedIndexes != null && !this.rightNotMatchedIndexes.isEmpty()) {
                assert (this.lastPushedInd >= 0);
                this.inLoop = true;
                try {
                    this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd);
                    while (true) {
                        this.checkState();
                        if (this.lastPushedInd < 0) {
                            break;
                        }
                        RowT row = this.outputRowFactory.concat(this.leftRowFactory.create(), this.rightMaterialized.get(this.lastPushedInd));
                        this.rightNotMatchedIndexes.clear(this.lastPushedInd);
                        --this.requested;
                        this.downstream().push(row);
                        if (this.lastPushedInd == Integer.MAX_VALUE) break;
                        if (this.requested <= 0) {
                            break;
                        }
                        this.lastPushedInd = this.rightNotMatchedIndexes.nextSetBit(this.lastPushedInd + 1);
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty() && this.rightNotMatchedIndexes.isEmpty()) {
                this.requested = 0;
                this.rightMaterialized.clear();
                this.downstream().end();
            }
        }
    }

    private static class SemiJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private int rightIdx;

        private SemiJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory) {
            super(ctx, cond, outputRowFactory);
        }

        @Override
        protected void rewindInternal() {
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                    }
                    boolean matched = false;
                    while (!matched && this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                        this.checkState();
                        if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                        --this.requested;
                        this.downstream().push(this.left);
                        matched = true;
                    }
                    if (!matched && this.rightIdx != this.rightMaterialized.size()) continue;
                    this.left = null;
                    this.rightIdx = 0;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.rightMaterialized.clear();
                this.downstream().end();
                this.requested = 0;
            }
        }
    }

    private static class AntiJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private int rightIdx;

        private AntiJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> outputRowFactory) {
            super(ctx, cond, outputRowFactory);
        }

        @Override
        protected void rewindInternal() {
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                        }
                        boolean matched = false;
                        while (!matched && this.rightIdx < this.rightMaterialized.size()) {
                            this.checkState();
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            matched = true;
                        }
                        if (!matched) {
                            --this.requested;
                            this.downstream().push(this.left);
                        }
                        this.left = null;
                        this.rightIdx = 0;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.waitingRight == 0) {
                this.waitingRight = 512;
                this.rightSource().request(512);
            }
            if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
                this.waitingLeft = 512;
                this.leftSource().request(512);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.rightMaterialized.clear();
                this.downstream().end();
            }
        }
    }
}

