/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageDestroyedException;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.util.MvPartitionStorages;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryTableStorage
implements MvTableStorage {
    private final MvPartitionStorages<AbstractPageMemoryMvPartitionStorage> mvPartitionStorages;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final StorageTableDescriptor tableDescriptor;
    private final StorageIndexDescriptorSupplier indexDescriptorSupplier;

    AbstractPageMemoryTableStorage(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) {
        this.tableDescriptor = tableDescriptor;
        this.indexDescriptorSupplier = indexDescriptorSupplier;
        this.mvPartitionStorages = new MvPartitionStorages(tableDescriptor.getId(), tableDescriptor.getPartitions());
    }

    public StorageIndexDescriptorSupplier getIndexDescriptorSupplier() {
        return this.indexDescriptorSupplier;
    }

    public abstract DataRegion<?> dataRegion();

    public abstract AbstractPageMemoryStorageEngine engine();

    public CompletableFuture<Void> destroy() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        return ((CompletableFuture)this.mvPartitionStorages.getAllForCloseOrDestroy().thenCompose(storages -> CompletableFuture.allOf((CompletableFuture[])storages.stream().map(this::destroyMvPartitionStorage).toArray(CompletableFuture[]::new)))).whenComplete((unused, throwable) -> {
            if (throwable == null) {
                this.finishDestruction();
            }
        });
    }

    protected abstract void finishDestruction();

    public abstract AbstractPageMemoryMvPartitionStorage createMvPartitionStorage(int var1) throws StorageException;

    abstract CompletableFuture<Void> destroyMvPartitionStorage(AbstractPageMemoryMvPartitionStorage var1);

    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.create(partitionId, partId -> {
            AbstractPageMemoryMvPartitionStorage partition = this.createMvPartitionStorage(partitionId);
            partition.start();
            return partition;
        }));
    }

    @Nullable
    public MvPartitionStorage getMvPartition(int partitionId) {
        return this.busy(() -> (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId));
    }

    public CompletableFuture<Void> destroyPartition(int partitionId) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletableFuture completableFuture = this.mvPartitionStorages.destroy(partitionId, this::destroyMvPartitionStorage);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public SortedIndexStorage getOrCreateSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        return this.busy(() -> {
            AbstractPageMemoryMvPartitionStorage partitionStorage = (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId);
            if (partitionStorage == null) {
                throw new StorageException(StorageUtils.createMissingMvPartitionErrorMessage((int)partitionId));
            }
            return partitionStorage.getOrCreateSortedIndex(indexDescriptor);
        });
    }

    public HashIndexStorage getOrCreateHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        return this.busy(() -> {
            AbstractPageMemoryMvPartitionStorage partitionStorage = (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId);
            if (partitionStorage == null) {
                throw new StorageException(StorageUtils.createMissingMvPartitionErrorMessage((int)partitionId));
            }
            return partitionStorage.getOrCreateHashIndex(indexDescriptor);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> destroyIndex(int indexId) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            List storages = this.mvPartitionStorages.getAll();
            CompletableFuture[] destroyFutures = new CompletableFuture[storages.size()];
            for (int i = 0; i < storages.size(); ++i) {
                AbstractPageMemoryMvPartitionStorage storage = (AbstractPageMemoryMvPartitionStorage)storages.get(i);
                try {
                    destroyFutures[i] = ((CompletableFuture)((CompletableFuture)storage.runConsistently(locker -> storage.destroyIndex(indexId))).handle((res, ex) -> {
                        if (ex != null && AbstractPageMemoryTableStorage.isIgnorableIndexDestructionException(ex)) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        return CompletableFutures.completedOrFailedFuture((Object)res, (Throwable)ex);
                    })).thenCompose(Function.identity());
                    continue;
                }
                catch (StorageDestroyedException e) {
                    destroyFutures[i] = CompletableFutures.nullCompletedFuture();
                }
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(destroyFutures);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static boolean isIgnorableIndexDestructionException(Throwable ex) {
        Throwable cause = ExceptionUtils.unwrapCause((Throwable)ex);
        return cause instanceof StorageDestroyedException || cause instanceof GradualTaskExecutor.GradualTaskCancellationException;
    }

    public void close() throws StorageException {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        try {
            CompletableFuture allForCloseOrDestroy = this.mvPartitionStorages.getAllForCloseOrDestroy();
            IgniteUtils.closeAllManually(((List)allForCloseOrDestroy.get(10L, TimeUnit.SECONDS)).stream());
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop PageMemory table storage: " + this.getTableId(), (Throwable)e);
        }
    }

    private <V> V busy(Supplier<V> supplier) {
        return (V)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, supplier);
    }

    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.mvPartitionStorages.startRebalance(partitionId, mvPartitionStorage -> {
            mvPartitionStorage.startRebalance();
            return this.clearStorageAndUpdateDataStructures((AbstractPageMemoryMvPartitionStorage)mvPartitionStorage).thenAccept(unused -> mvPartitionStorage.runConsistently(locker -> {
                mvPartitionStorage.lastAppliedOnRebalance(-1L, -1L);
                return null;
            }));
        }));
    }

    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.mvPartitionStorages.abortRebalance(partitionId, mvPartitionStorage -> this.clearStorageAndUpdateDataStructures((AbstractPageMemoryMvPartitionStorage)mvPartitionStorage).thenAccept(unused -> {
            mvPartitionStorage.runConsistently(locker -> {
                mvPartitionStorage.lastAppliedOnRebalance(0L, 0L);
                return null;
            });
            mvPartitionStorage.completeRebalance();
        })));
    }

    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.mvPartitionStorages.finishRebalance(partitionId, mvPartitionStorage -> {
            mvPartitionStorage.runConsistently(locker -> {
                mvPartitionStorage.lastAppliedOnRebalance(partitionMeta.lastAppliedIndex(), partitionMeta.lastAppliedTerm());
                mvPartitionStorage.committedGroupConfigurationOnRebalance(partitionMeta.groupConfig());
                if (partitionMeta.primaryReplicaNodeId() != null) {
                    assert (partitionMeta.primaryReplicaNodeName() != null);
                    mvPartitionStorage.updateLeaseOnRebalance(partitionMeta.leaseStartTime(), partitionMeta.primaryReplicaNodeId(), partitionMeta.primaryReplicaNodeName());
                }
                return null;
            });
            mvPartitionStorage.completeRebalance();
            return CompletableFutures.nullCompletedFuture();
        }));
    }

    public CompletableFuture<Void> clearPartition(int partitionId) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.mvPartitionStorages.clear(partitionId, mvPartitionStorage -> {
            try {
                mvPartitionStorage.startCleanup();
                return this.clearStorageAndUpdateDataStructures((AbstractPageMemoryMvPartitionStorage)mvPartitionStorage).whenComplete((unused, throwable) -> mvPartitionStorage.finishCleanup());
            }
            catch (StorageException e) {
                mvPartitionStorage.finishCleanup();
                throw e;
            }
            catch (Throwable t) {
                mvPartitionStorage.finishCleanup();
                throw new StorageException("Failed to cleanup storage: [{}]", t, new Object[]{mvPartitionStorage.createStorageInfo()});
            }
        }));
    }

    abstract CompletableFuture<Void> clearStorageAndUpdateDataStructures(AbstractPageMemoryMvPartitionStorage var1);

    public int getTableId() {
        return this.tableDescriptor.getId();
    }

    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return this.busy(() -> {
            AbstractPageMemoryMvPartitionStorage partitionStorage = (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId);
            if (partitionStorage == null) {
                throw new StorageException(StorageUtils.createMissingMvPartitionErrorMessage((int)partitionId));
            }
            return partitionStorage.getIndex(indexId);
        });
    }

    public StorageTableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }
}

