/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ReadOnlyMultiRowPkReplicaRequestDeserializer
implements MessageDeserializer<ReadOnlyMultiRowPkReplicaRequest> {
    private final ReadOnlyMultiRowPkReplicaRequestBuilder msg;

    ReadOnlyMultiRowPkReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlyMultiRowPkReplicaRequest();
    }

    public Class<ReadOnlyMultiRowPkReplicaRequest> klass() {
        return ReadOnlyMultiRowPkReplicaRequest.class;
    }

    public ReadOnlyMultiRowPkReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.coordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("primaryKeys", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.primaryKeys((List<ByteBuffer>)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("readTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                int ordinalShifted = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType tmp = ordinalShifted == 0 ? null : RequestType.fromOrdinal(ordinalShifted - 1);
                this.msg.requestType(tmp);
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                UUID tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlyMultiRowPkReplicaRequest.class);
    }
}

