/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.future;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class OrderingFuture<T> {
    private static final int INT_FALSE = 0;
    private static final int INT_TRUE = 1;
    private static final VarHandle STATE;
    private static final VarHandle COMPLETION_STARTED;
    private volatile State<T> state = State.empty();
    private volatile int completionStarted = 0;
    private final CountDownLatch completionValuesReadyLatch = new CountDownLatch(1);

    public static <T> OrderingFuture<T> completedFuture(@Nullable T result) {
        OrderingFuture<T> future = new OrderingFuture<T>();
        future.complete(result);
        return future;
    }

    public static <T> OrderingFuture<T> failedFuture(Throwable ex) {
        OrderingFuture<T> future = new OrderingFuture<T>();
        future.completeExceptionally(ex);
        return future;
    }

    public static <T> OrderingFuture<T> adapt(CompletableFuture<T> adaptee) {
        OrderingFuture future = new OrderingFuture();
        adaptee.whenComplete((T res, U ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(res);
            }
        });
        return future;
    }

    public void complete(@Nullable T result) {
        this.completeInternal(result, null);
    }

    public void completeExceptionally(Throwable ex) {
        this.completeInternal(null, ex);
    }

    private void completeInternal(@Nullable T result, @Nullable Throwable ex) {
        assert (ex == null || result == null);
        if (!COMPLETION_STARTED.compareAndSet(this, 0, 1)) {
            this.waitForCompletionValuesVisibility();
            return;
        }
        assert (this.state.phase == Phase.INCOMPLETE);
        this.switchToNotifyingStage(result, ex);
        assert (this.state.phase == Phase.NOTIFYING);
        this.completionValuesReadyLatch.countDown();
        this.completeNotificationStage(result, ex);
        assert (this.state.phase == Phase.COMPLETED);
    }

    private void waitForCompletionValuesVisibility() {
        try {
            this.completionValuesReadyLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void switchToNotifyingStage(@Nullable T result, @Nullable Throwable ex) {
        State<T> newState;
        State<T> prevState;
        while (!this.replaceState(prevState = this.state, newState = prevState.switchToNotifying(result, ex))) {
        }
    }

    private void completeNotificationStage(@Nullable T result, @Nullable Throwable ex) {
        State<T> newState;
        State<T> prevState;
        ListNode lastNotifiedNode = null;
        do {
            prevState = this.state;
            newState = prevState.switchToCompleted();
            this.notifyDependents(result, ex, prevState.dependentsQueueTail, lastNotifiedNode);
            lastNotifiedNode = prevState.dependentsQueueTail;
        } while (!this.replaceState(prevState, newState));
    }

    private boolean replaceState(State<T> prevState, State<T> newState) {
        return STATE.compareAndSet(this, prevState, newState);
    }

    private void notifyDependents(@Nullable T result, @Nullable Throwable ex, @Nullable ListNode<T> dependents, @Nullable ListNode<T> lastNotifiedNode) {
        if (dependents != null) {
            dependents.notifyHeadToTail(result, ex, lastNotifiedNode);
        }
    }

    public boolean isCompletedExceptionally() {
        return this.state.exception != null;
    }

    public void whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        State<T> newState;
        State<? super T> prevState;
        WhenComplete<? super T> dependent = null;
        do {
            if ((prevState = this.state).completionQueueProcessed()) {
                OrderingFuture.acceptQuietly(action, prevState.result, prevState.exception);
                return;
            }
            if (dependent != null) continue;
            dependent = new WhenComplete<T>(action);
        } while (!this.replaceState(prevState, newState = prevState.enqueueDependent(dependent)));
    }

    private static <T> void acceptQuietly(BiConsumer<? super T, ? super Throwable> action, @Nullable T result, @Nullable Throwable ex) {
        try {
            action.accept(result, ex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <U> CompletableFuture<U> thenComposeToCompletable(Function<? super T, ? extends CompletableFuture<U>> mapper) {
        State<T> newState;
        State<T> prevState;
        ThenComposeToCompletable dependent = null;
        do {
            if ((prevState = this.state).completionQueueProcessed()) {
                if (prevState.exception != null) {
                    return CompletableFuture.failedFuture(OrderingFuture.wrapWithCompletionException(prevState.exception));
                }
                return OrderingFuture.applyMapperToCompletable(mapper, prevState.result);
            }
            if (dependent != null) continue;
            dependent = new ThenComposeToCompletable(new CompletableFuture(), mapper);
        } while (!this.replaceState(prevState, newState = prevState.enqueueDependent(dependent)));
        return dependent.resultFuture;
    }

    public <U> OrderingFuture<U> thenCompose(Function<? super T, ? extends OrderingFuture<U>> mapper) {
        State<T> newState;
        State<T> prevState;
        ThenCompose<? super T, T> dependent = null;
        do {
            if ((prevState = this.state).completionQueueProcessed()) {
                if (prevState.exception != null) {
                    return OrderingFuture.failedFuture(OrderingFuture.wrapWithCompletionException(prevState.exception));
                }
                return OrderingFuture.applyMapperToOrdering(mapper, prevState.result);
            }
            if (dependent != null) continue;
            dependent = new ThenCompose<T, T>(new OrderingFuture<T>(), mapper);
        } while (!this.replaceState(prevState, newState = prevState.enqueueDependent(dependent)));
        return dependent.resultFuture;
    }

    public <U> OrderingFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> mapper) {
        State<T> newState;
        State<T> prevState;
        Handle<? super T, ? extends U> dependent = null;
        do {
            if ((prevState = this.state).completionQueueProcessed()) {
                try {
                    U mappingResult = mapper.apply(prevState.result, prevState.exception);
                    return OrderingFuture.completedFuture(mappingResult);
                }
                catch (Throwable t) {
                    return OrderingFuture.failedFuture(t);
                }
            }
            if (dependent != null) continue;
            dependent = new Handle<T, U>(new OrderingFuture<T>(), mapper);
        } while (!this.replaceState(prevState, newState = prevState.enqueueDependent(dependent)));
        return dependent.resultFuture;
    }

    private static CompletionException wrapWithCompletionException(Throwable ex) {
        return ex instanceof CompletionException ? (CompletionException)ex : new CompletionException(ex);
    }

    private static <T, U> CompletableFuture<U> applyMapperToCompletable(Function<? super T, ? extends CompletableFuture<U>> mapper, @Nullable T result) {
        try {
            return mapper.apply(result);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private static <T, U> OrderingFuture<U> applyMapperToOrdering(Function<? super T, ? extends OrderingFuture<U>> mapper, @Nullable T result) {
        try {
            return mapper.apply(result);
        }
        catch (Throwable e) {
            return OrderingFuture.failedFuture(e);
        }
    }

    @Nullable
    public T getNow(@Nullable T valueIfAbsent) {
        State<T> currentState = this.state;
        if (currentState.completionValuesAvailable()) {
            if (currentState.exception != null) {
                throw OrderingFuture.wrapWithCompletionException(currentState.exception);
            }
            return currentState.result;
        }
        return valueIfAbsent;
    }

    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean completedInTime = this.completionValuesReadyLatch.await(timeout, unit);
        if (!completedInTime) {
            throw new TimeoutException();
        }
        State<T> currentState = this.state;
        if (currentState.exception instanceof CancellationException) {
            throw (CancellationException)currentState.exception;
        }
        if (currentState.exception != null) {
            throw this.exceptionForThrowingFromGet(currentState);
        }
        return currentState.result;
    }

    private ExecutionException exceptionForThrowingFromGet(State<T> currentState) {
        Throwable unwrapped = currentState.exception;
        assert (unwrapped != null);
        Throwable cause = unwrapped.getCause();
        if (cause != null) {
            unwrapped = cause;
        }
        return new ExecutionException(unwrapped);
    }

    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.whenComplete(CompletableFutures.copyStateTo(completableFuture));
        return completableFuture;
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(OrderingFuture.class, "state", State.class);
            COMPLETION_STARTED = MethodHandles.lookup().findVarHandle(OrderingFuture.class, "completionStarted", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class State<T> {
        private static final State<?> INCOMPLETE_STATE = new State<Object>(Phase.INCOMPLETE, null, null, null);
        private final Phase phase;
        private final T result;
        private final Throwable exception;
        private final ListNode<T> dependentsQueueTail;

        private State(Phase phase, @Nullable T result, @Nullable Throwable exception, @Nullable ListNode<T> dependentsQueueTail) {
            this.phase = phase;
            this.result = result;
            this.exception = exception;
            this.dependentsQueueTail = dependentsQueueTail;
        }

        private static <T> State<T> empty() {
            return INCOMPLETE_STATE;
        }

        public boolean completionValuesAvailable() {
            return this.phase != Phase.INCOMPLETE;
        }

        public boolean completionQueueProcessed() {
            return this.phase == Phase.COMPLETED;
        }

        public State<T> switchToNotifying(@Nullable T completionResult, @Nullable Throwable completionCause) {
            return new State<T>(Phase.NOTIFYING, completionResult, completionCause, this.dependentsQueueTail);
        }

        public State<T> switchToCompleted() {
            return new State<T>(Phase.COMPLETED, this.result, this.exception, null);
        }

        public State<T> enqueueDependent(DependentAction<T> dependent) {
            return new State<T>(this.phase, this.result, this.exception, new ListNode<T>(dependent, this.dependentsQueueTail));
        }
    }

    private static enum Phase {
        INCOMPLETE,
        NOTIFYING,
        COMPLETED;

    }

    private static class ListNode<T> {
        private final DependentAction<T> dependent;
        @Nullable
        private final ListNode<T> prev;

        private ListNode(DependentAction<T> dependent, @Nullable ListNode<T> prev) {
            this.dependent = dependent;
            this.prev = prev;
        }

        public void notifyHeadToTail(@Nullable T result, @Nullable Throwable exception, @Nullable ListNode<T> lastNotifiedNode) {
            ArrayDeque<ListNode<T>> stack = new ArrayDeque<ListNode<T>>();
            ListNode<T> node = this;
            while (node != null && node != lastNotifiedNode) {
                stack.addFirst(node);
                node = node.prev;
            }
            NotificationContext context = new NotificationContext();
            while (!stack.isEmpty()) {
                ListNode node2 = (ListNode)stack.removeFirst();
                try {
                    node2.dependent.onCompletion(result, exception, context);
                }
                catch (Exception exception2) {}
            }
        }
    }

    private static class WhenComplete<T>
    implements DependentAction<T> {
        private final BiConsumer<? super T, ? super Throwable> action;

        private WhenComplete(BiConsumer<? super T, ? super Throwable> action) {
            this.action = action;
        }

        @Override
        public void onCompletion(@Nullable T result, @Nullable Throwable ex, NotificationContext context) {
            OrderingFuture.acceptQuietly(this.action, result, ex);
        }
    }

    private static interface DependentAction<T> {
        public void onCompletion(@Nullable T var1, @Nullable Throwable var2, NotificationContext var3);
    }

    private static class ThenComposeToCompletable<T, U>
    implements DependentAction<T>,
    BiConsumer<U, Throwable> {
        private final CompletableFuture<U> resultFuture;
        private final Function<? super T, ? extends CompletableFuture<U>> mapper;

        private ThenComposeToCompletable(CompletableFuture<U> resultFuture, Function<? super T, ? extends CompletableFuture<U>> mapper) {
            this.resultFuture = resultFuture;
            this.mapper = mapper;
        }

        @Override
        public void onCompletion(@Nullable T result, @Nullable Throwable ex, NotificationContext context) {
            if (ex != null) {
                this.resultFuture.completeExceptionally(context.completionExceptionCaching(ex));
                return;
            }
            try {
                CompletableFuture<U> mapResult = this.mapper.apply(result);
                mapResult.whenComplete((BiConsumer)this);
            }
            catch (Throwable e) {
                this.resultFuture.completeExceptionally(e);
            }
        }

        @Override
        public void accept(U mapRes, Throwable mapEx) {
            if (mapEx != null) {
                this.resultFuture.completeExceptionally(mapEx);
            } else {
                this.resultFuture.complete(mapRes);
            }
        }
    }

    private static class ThenCompose<T, U>
    implements DependentAction<T>,
    BiConsumer<U, Throwable> {
        private final OrderingFuture<U> resultFuture;
        private final Function<? super T, ? extends OrderingFuture<U>> mapper;

        private ThenCompose(OrderingFuture<U> resultFuture, Function<? super T, ? extends OrderingFuture<U>> mapper) {
            this.resultFuture = resultFuture;
            this.mapper = mapper;
        }

        @Override
        public void onCompletion(@Nullable T result, @Nullable Throwable ex, NotificationContext context) {
            if (ex != null) {
                this.resultFuture.completeExceptionally(context.completionExceptionCaching(ex));
                return;
            }
            try {
                OrderingFuture<U> mapResult = this.mapper.apply(result);
                mapResult.whenComplete(this);
            }
            catch (Throwable e) {
                this.resultFuture.completeExceptionally(e);
            }
        }

        @Override
        public void accept(U mapRes, Throwable mapEx) {
            if (mapEx != null) {
                this.resultFuture.completeExceptionally(mapEx);
            } else {
                this.resultFuture.complete(mapRes);
            }
        }
    }

    private static class Handle<T, U>
    implements DependentAction<T> {
        private final OrderingFuture<U> resultFuture;
        private final BiFunction<? super T, Throwable, ? extends U> action;

        private Handle(OrderingFuture<U> resultFuture, BiFunction<? super T, Throwable, ? extends U> action) {
            this.resultFuture = resultFuture;
            this.action = action;
        }

        @Override
        public void onCompletion(@Nullable T result, @Nullable Throwable ex, NotificationContext context) {
            try {
                this.resultFuture.complete(this.action.apply(result, ex));
            }
            catch (Throwable t) {
                this.resultFuture.completeExceptionally(t);
            }
        }
    }

    private static class NotificationContext {
        @Nullable
        private CompletionException completionException;

        private NotificationContext() {
        }

        CompletionException completionExceptionCaching(Throwable cause) {
            if (this.completionException == null) {
                this.completionException = OrderingFuture.wrapWithCompletionException(cause);
            }
            return this.completionException;
        }
    }
}

