/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.lang;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ByteArray
implements Comparable<ByteArray> {
    private final byte[] arr;

    public ByteArray(byte[] arr) {
        this.arr = arr;
    }

    public ByteArray(String s) {
        this(s.getBytes(StandardCharsets.UTF_8));
    }

    public ByteArray(ByteArray other) {
        this.arr = other.arr;
    }

    public static ByteArray fromString(String s) {
        return new ByteArray(s);
    }

    public byte[] bytes() {
        return this.arr;
    }

    public int length() {
        return this.arr.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray byteArray = (ByteArray)o;
        return Arrays.equals(this.arr, byteArray.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    @Override
    public int compareTo(ByteArray other) {
        return Arrays.compare(this.arr, other.arr);
    }

    public String toString() {
        return new String(this.arr, StandardCharsets.UTF_8);
    }
}

