/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.explain.ExplainUtils;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class MultiStepPlan
implements ExplainablePlan {
    private final PlanId id;
    private final SqlQueryType type;
    private final ResultSetMetadata meta;
    private final IgniteRel root;
    private final ParameterMetadata parameterMetadata;
    private final int catalogVersion;
    @Nullable
    private final QueryPlan fastPlan;
    private final int numSources;
    private final PartitionAwarenessMetadata partitionAwarenessMetadata;
    private final PartitionPruningMetadata partitionPruningMetadata;

    public MultiStepPlan(PlanId id, SqlQueryType type, IgniteRel root, ResultSetMetadata meta, ParameterMetadata parameterMetadata, int catalogVersion, int numSources, @Nullable QueryPlan fastPlan, @Nullable PartitionAwarenessMetadata partitionAwarenessMetadata, @Nullable PartitionPruningMetadata partitionPruningMetadata) {
        this.id = id;
        this.type = type;
        this.root = root;
        this.meta = meta;
        this.parameterMetadata = parameterMetadata;
        this.catalogVersion = catalogVersion;
        this.fastPlan = fastPlan;
        this.numSources = numSources;
        this.partitionAwarenessMetadata = partitionAwarenessMetadata;
        this.partitionPruningMetadata = partitionPruningMetadata;
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.partitionAwarenessMetadata;
    }

    @Override
    @Nullable
    public PartitionPruningMetadata partitionPruningMetadata() {
        return this.partitionPruningMetadata;
    }

    @Override
    public int numSources() {
        return this.numSources;
    }

    @Override
    public SqlQueryType type() {
        return this.type;
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.root, Commons.cluster());
        return ExplainUtils.toString(clonedRoot);
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    @Override
    public IgniteRel getRel() {
        return this.root;
    }

    @Nullable
    public QueryPlan fastPlan() {
        return this.fastPlan;
    }
}

