/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.impl;

import org.apache.ignite.internal.eventlog.api.Event;
import org.apache.ignite.internal.eventlog.api.Sink;
import org.apache.ignite.internal.eventlog.config.schema.LogSinkView;
import org.apache.ignite.internal.eventlog.ser.EventSerializer;

class LogSink
implements Sink {
    private final System.Logger logger;
    private final EventSerializer serializer;
    private final String level;

    LogSink(LogSinkView cfg, EventSerializer eventSerializer) {
        this.level = cfg.level();
        this.logger = System.getLogger(cfg.criteria());
        this.serializer = eventSerializer;
    }

    @Override
    public void write(Event event) {
        this.logger.log(System.Logger.Level.valueOf(this.level), this.serializer.serialize(event));
    }
}

