/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignment;
import org.apache.ignite.internal.processors.affinity.GridAffinityMessage;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GridAffinityUtils {
    static Callable<GridTuple3<GridAffinityMessage, GridAffinityMessage, GridAffinityAssignment>> affinityJob(String cacheName, AffinityTopologyVersion topVer) {
        return new AffinityJob(cacheName, topVer);
    }

    private static GridAffinityMessage affinityMessage(GridKernalContext ctx, Object o) throws IgniteCheckedException {
        Class<?> cls = o.getClass();
        GridDeployment dep = ctx.deploy().deploy(cls, cls.getClassLoader());
        if (dep == null) {
            throw new IgniteDeploymentCheckedException("Failed to deploy affinity object with class: " + cls.getName());
        }
        return new GridAffinityMessage(U.marshal(ctx, o), cls.getName(), dep.classLoaderId(), dep.deployMode(), dep.userVersion(), dep.participants());
    }

    static Object unmarshall(GridKernalContext ctx, UUID sndNodeId, GridAffinityMessage msg) throws IgniteCheckedException {
        GridDeployment dep = ctx.deploy().getGlobalDeployment(msg.deploymentMode(), msg.sourceClassName(), msg.sourceClassName(), msg.userVersion(), sndNodeId, msg.classLoaderId(), msg.loaderParticipants(), null);
        if (dep == null) {
            throw new IgniteDeploymentCheckedException("Failed to obtain affinity object (is peer class loading turned on?): " + msg);
        }
        Object src = U.unmarshal(ctx, msg.source(), U.resolveClassLoader(dep.classLoader(), ctx.config()));
        ctx.resource().inject(dep, dep.deployedClass(msg.sourceClassName(), new String[0]).get1(), src);
        return src;
    }

    private GridAffinityUtils() {
    }

    @GridInternal
    private static class AffinityJob
    implements Callable<GridTuple3<GridAffinityMessage, GridAffinityMessage, GridAffinityAssignment>>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;
        private String cacheName;
        private AffinityTopologyVersion topVer;

        private AffinityJob(@Nullable String cacheName, @NotNull AffinityTopologyVersion topVer) {
            this.cacheName = cacheName;
            this.topVer = topVer;
        }

        public AffinityJob() {
        }

        @Override
        public GridTuple3<GridAffinityMessage, GridAffinityMessage, GridAffinityAssignment> call() throws Exception {
            assert (this.ignite != null);
            assert (this.log != null);
            IgniteKernal kernal = (IgniteKernal)this.ignite;
            GridCacheContext cctx = kernal.internalCache(this.cacheName).context();
            assert (cctx != null);
            GridKernalContext ctx = kernal.context();
            cctx.affinity().affinityReadyFuture(this.topVer).get();
            AffinityAssignment assign0 = cctx.affinity().assignment(this.topVer);
            return F.t(GridAffinityUtils.affinityMessage(ctx, cctx.config().getAffinity()), GridAffinityUtils.affinityMessage(ctx, cctx.config().getAffinityMapper()), new GridAffinityAssignment(this.topVer, assign0.assignment(), assign0.idealAssignment()));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.cacheName);
            out.writeObject(this.topVer);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cacheName = U.readString(in);
            this.topVer = (AffinityTopologyVersion)in.readObject();
        }
    }
}

