/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatistics;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class ObjectStatisticsImpl
implements Cloneable,
ObjectStatistics {
    private final long rowsCnt;
    @GridToStringInclude
    private final Map<String, ColumnStatistics> colNameToStat;

    public ObjectStatisticsImpl(long rowsCnt, Map<String, ColumnStatistics> colNameToStat) {
        assert (rowsCnt >= 0L) : "rowsCnt >= 0";
        assert (colNameToStat != null) : "colNameToStat != null";
        this.rowsCnt = rowsCnt;
        this.colNameToStat = colNameToStat;
    }

    public long rowCount() {
        return this.rowsCnt;
    }

    public ColumnStatistics columnStatistics(String colName) {
        return this.colNameToStat.get(colName);
    }

    public Map<String, ColumnStatistics> columnsStatistics() {
        return this.colNameToStat;
    }

    public ObjectStatisticsImpl clone() {
        return new ObjectStatisticsImpl(this.rowsCnt, new HashMap<String, ColumnStatistics>(this.colNameToStat));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStatisticsImpl that = (ObjectStatisticsImpl)o;
        return this.rowsCnt == that.rowsCnt && Objects.equals(this.colNameToStat, that.colNameToStat);
    }

    public int hashCode() {
        return Objects.hash(this.rowsCnt, this.colNameToStat);
    }

    public String toString() {
        return S.toString(ObjectStatisticsImpl.class, this);
    }

    public <T extends ObjectStatisticsImpl> T subtract(Set<String> cols) {
        ObjectStatisticsImpl res = this.clone();
        for (String col : cols) {
            res.columnsStatistics().remove(col);
        }
        return (T)res;
    }
}

