/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.lang.ComponentStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterNodeResolver;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partition.replicator.ReplicaPrimacy;
import org.apache.ignite3.internal.partition.replicator.ReplicaPrimacyEngine;
import org.apache.ignite3.internal.partition.replicator.ReplicaTableProcessor;
import org.apache.ignite3.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite3.internal.partition.replicator.TableAwareReplicaRequestPreProcessor;
import org.apache.ignite3.internal.partition.replicator.TxRecoveryEngine;
import org.apache.ignite3.internal.partition.replicator.handlers.MinimumActiveTxTimeReplicaRequestHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.ReplicaSafeTimeSyncRequestHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.TxCleanupRecoveryRequestHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.TxFinishReplicaRequestHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.TxRecoveryMessageHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.TxStateCommitPartitionReplicaRequestHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.VacuumTxStateReplicaRequestHandler;
import org.apache.ignite3.internal.partition.replicator.handlers.WriteIntentSwitchRequestHandler;
import org.apache.ignite3.internal.partition.replicator.network.replication.UpdateMinimumActiveTxBeginTimeReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.schema.ValidationSchemasSource;
import org.apache.ignite3.internal.partition.replicator.schemacompat.SchemaCompatibilityValidator;
import org.apache.ignite3.internal.placementdriver.LeasePlacementDriver;
import org.apache.ignite3.internal.raft.service.RaftCommandRunner;
import org.apache.ignite3.internal.replicator.ReplicaResult;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.replicator.listener.ReplicaListener;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite3.internal.replicator.message.TableAware;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.message.TxCleanupRecoveryRequest;
import org.apache.ignite3.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite3.internal.tx.message.TxRecoveryMessage;
import org.apache.ignite3.internal.tx.message.TxStateCommitPartitionRequest;
import org.apache.ignite3.internal.tx.message.VacuumTxStateReplicaRequest;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.jetbrains.annotations.VisibleForTesting;

public class ZonePartitionReplicaListener
implements ReplicaListener {
    private static final IgniteLogger LOG = Loggers.forClass(ZonePartitionReplicaListener.class);
    private final Map<Integer, ReplicaTableProcessor> replicaProcessors = new ConcurrentHashMap<Integer, ReplicaTableProcessor>();
    private final RaftCommandRunner raftClient;
    private final FailureProcessor failureProcessor;
    private final ZonePartitionId replicationGroupId;
    private final ReplicaPrimacyEngine replicaPrimacyEngine;
    private final TableAwareReplicaRequestPreProcessor tableAwareReplicaRequestPreProcessor;
    private final TxFinishReplicaRequestHandler txFinishReplicaRequestHandler;
    private final WriteIntentSwitchRequestHandler writeIntentSwitchRequestHandler;
    private final TxStateCommitPartitionReplicaRequestHandler txStateCommitPartitionReplicaRequestHandler;
    private final TxRecoveryMessageHandler txRecoveryMessageHandler;
    private final TxCleanupRecoveryRequestHandler txCleanupRecoveryRequestHandler;
    private final MinimumActiveTxTimeReplicaRequestHandler minimumActiveTxTimeReplicaRequestHandler;
    private final VacuumTxStateReplicaRequestHandler vacuumTxStateReplicaRequestHandler;
    private final ReplicaSafeTimeSyncRequestHandler replicaSafeTimeSyncRequestHandler;

    public ZonePartitionReplicaListener(TxStatePartitionStorage txStatePartitionStorage, ClockService clockService, TxManager txManager, ValidationSchemasSource validationSchemasSource, SchemaSyncService schemaSyncService, CatalogService catalogService, LeasePlacementDriver placementDriver, ClusterNodeResolver clusterNodeResolver, RaftCommandRunner raftClient, FailureProcessor failureProcessor, NodeProperties nodeProperties, InternalClusterNode localNode, ZonePartitionId replicationGroupId) {
        this.raftClient = raftClient;
        this.failureProcessor = failureProcessor;
        this.replicationGroupId = replicationGroupId;
        this.replicaPrimacyEngine = new ReplicaPrimacyEngine(placementDriver, clockService, replicationGroupId, localNode);
        this.tableAwareReplicaRequestPreProcessor = new TableAwareReplicaRequestPreProcessor(clockService, new SchemaCompatibilityValidator(validationSchemasSource, catalogService, schemaSyncService), schemaSyncService, nodeProperties);
        ReplicationRaftCommandApplicator raftCommandApplicator = new ReplicationRaftCommandApplicator(raftClient, replicationGroupId);
        TxRecoveryEngine txRecoveryEngine = new TxRecoveryEngine(txManager, clusterNodeResolver, replicationGroupId, ZonePartitionReplicaListener::createAbandonedTxRecoveryEnlistment);
        this.txFinishReplicaRequestHandler = new TxFinishReplicaRequestHandler(txStatePartitionStorage, clockService, txManager, validationSchemasSource, schemaSyncService, catalogService, raftClient, replicationGroupId);
        this.writeIntentSwitchRequestHandler = new WriteIntentSwitchRequestHandler(this.replicaProcessors::get, clockService, schemaSyncService, catalogService, txManager, raftClient, replicationGroupId, this.tableAwareReplicaRequestPreProcessor);
        this.txStateCommitPartitionReplicaRequestHandler = new TxStateCommitPartitionReplicaRequestHandler(txStatePartitionStorage, txManager, clusterNodeResolver, localNode, txRecoveryEngine);
        this.txRecoveryMessageHandler = new TxRecoveryMessageHandler(txStatePartitionStorage, replicationGroupId, txRecoveryEngine);
        this.txCleanupRecoveryRequestHandler = new TxCleanupRecoveryRequestHandler(txStatePartitionStorage, txManager, failureProcessor, replicationGroupId);
        this.minimumActiveTxTimeReplicaRequestHandler = new MinimumActiveTxTimeReplicaRequestHandler(clockService, raftCommandApplicator);
        this.vacuumTxStateReplicaRequestHandler = new VacuumTxStateReplicaRequestHandler(raftCommandApplicator);
        this.replicaSafeTimeSyncRequestHandler = new ReplicaSafeTimeSyncRequestHandler(clockService, raftCommandApplicator);
    }

    private static PendingTxPartitionEnlistment createAbandonedTxRecoveryEnlistment(InternalClusterNode node) {
        return new PendingTxPartitionEnlistment(node.name(), 0L);
    }

    @Override
    public CompletableFuture<ReplicaResult> invoke(ReplicaRequest request, UUID senderId) {
        return ((CompletableFuture)this.replicaPrimacyEngine.validatePrimacy(request).thenCompose(replicaPrimacy -> this.processRequest(request, (ReplicaPrimacy)replicaPrimacy, senderId))).thenApply(res -> {
            if (res instanceof ReplicaResult) {
                return (ReplicaResult)res;
            }
            return new ReplicaResult(res, null);
        });
    }

    private CompletableFuture<?> processRequest(ReplicaRequest request, ReplicaPrimacy replicaPrimacy, UUID senderId) {
        if (request instanceof TableAware) {
            return this.processTableAwareRequest(request, replicaPrimacy, senderId);
        }
        if (request instanceof TxFinishReplicaRequest) {
            return this.txFinishReplicaRequestHandler.handle((TxFinishReplicaRequest)request).thenApply(res -> new ReplicaResult(res, null));
        }
        if (request instanceof WriteIntentSwitchReplicaRequest) {
            return this.writeIntentSwitchRequestHandler.handle((WriteIntentSwitchReplicaRequest)request, senderId);
        }
        if (request instanceof TxStateCommitPartitionRequest) {
            return this.txStateCommitPartitionReplicaRequestHandler.handle((TxStateCommitPartitionRequest)request);
        }
        if (request instanceof TxRecoveryMessage) {
            return this.txRecoveryMessageHandler.handle((TxRecoveryMessage)request, senderId);
        }
        if (request instanceof TxCleanupRecoveryRequest) {
            return this.txCleanupRecoveryRequestHandler.handle((TxCleanupRecoveryRequest)request);
        }
        return this.processZoneReplicaRequest(request, replicaPrimacy);
    }

    private CompletableFuture<ReplicaResult> processTableAwareRequest(ReplicaRequest request, ReplicaPrimacy replicaPrimacy, UUID senderId) {
        return this.tableAwareReplicaRequestPreProcessor.preProcessTableAwareRequest(request, replicaPrimacy, senderId).thenCompose(ignored -> {
            int tableId = ((TableAware)((Object)request)).tableId();
            ReplicaTableProcessor replicaProcessor = this.replicaProcessors.get(tableId);
            if (replicaProcessor == null) {
                LOG.debug("Replica processor for table ID {} not found. Command will be ignored: {}", tableId, request.toStringForLightLogging());
                return CompletableFuture.failedFuture(new ComponentStoppingException("Table is already destroyed [tableId=" + tableId + "]"));
            }
            return replicaProcessor.process(request, replicaPrimacy, senderId);
        });
    }

    private CompletableFuture<?> processZoneReplicaRequest(ReplicaRequest request, ReplicaPrimacy replicaPrimacy) {
        if (request instanceof VacuumTxStateReplicaRequest) {
            return this.vacuumTxStateReplicaRequestHandler.handle((VacuumTxStateReplicaRequest)request);
        }
        if (request instanceof UpdateMinimumActiveTxBeginTimeReplicaRequest) {
            return this.minimumActiveTxTimeReplicaRequestHandler.handle((UpdateMinimumActiveTxBeginTimeReplicaRequest)request);
        }
        if (request instanceof ReplicaSafeTimeSyncRequest) {
            return this.replicaSafeTimeSyncRequestHandler.handle((ReplicaSafeTimeSyncRequest)request, replicaPrimacy.isPrimary());
        }
        LOG.warn("Non table request is not supported by the zone partition yet " + request, new Object[0]);
        return CompletableFuture.completedFuture(new ReplicaResult(null, null));
    }

    @Override
    public RaftCommandRunner raftClient() {
        return this.raftClient;
    }

    public void addTableReplicaProcessor(int tableId, Function<RaftCommandRunner, ReplicaTableProcessor> replicaListener) {
        this.replicaProcessors.put(tableId, replicaListener.apply(this.raftClient));
    }

    public void removeTableReplicaProcessor(int tableId) {
        this.replicaProcessors.remove(tableId);
    }

    @VisibleForTesting
    public Map<Integer, ReplicaTableProcessor> tableReplicaProcessors() {
        return this.replicaProcessors;
    }

    @Override
    public void onShutdown() {
        this.replicaProcessors.forEach((tableId, listener) -> {
            try {
                listener.onShutdown();
            }
            catch (Throwable th) {
                String errorMessage = String.format("Error during table partition listener stop for [tableId=%s, partitionId=%s].", tableId, this.replicationGroupId.partitionId());
                this.failureProcessor.process(new FailureContext(th, errorMessage));
            }
        });
    }
}

