/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class NetworkInterfaceAvailable {
    NetworkInterfaceAvailable() {
    }

    static class IsInvalidNetworkInterfaceIDNotFoundMatcher
    extends WaiterAcceptor<DescribeNetworkInterfacesResult> {
        IsInvalidNetworkInterfaceIDNotFoundMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "InvalidNetworkInterfaceID.NotFound".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsAvailableMatcher
    extends WaiterAcceptor<DescribeNetworkInterfacesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsAvailableMatcher() {
        }

        public boolean matches(DescribeNetworkInterfacesResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"available\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("NetworkInterfaces")), (JmesPathExpression)new JmesPathField("Status"));
        }
    }
}

