/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.Header;
import java.time.Duration;

public final class HttpClientOptions
extends ClientOptions {
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration NO_TIMEOUT = Duration.ZERO;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    @Override
    public HttpClientOptions setApplicationId(String applicationId) {
        super.setApplicationId(applicationId);
        return this;
    }

    @Override
    public HttpClientOptions setHeaders(Iterable<Header> headers) {
        super.setHeaders(headers);
        return this;
    }

    public HttpClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public HttpClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HttpClientOptions setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public Duration getWriteTimeout() {
        return HttpClientOptions.getTimeout(this.writeTimeout);
    }

    public HttpClientOptions responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public HttpClientOptions setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public Duration getResponseTimeout() {
        return HttpClientOptions.getTimeout(this.responseTimeout);
    }

    public HttpClientOptions readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpClientOptions setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return HttpClientOptions.getTimeout(this.readTimeout);
    }

    private static Duration getTimeout(Duration timeout) {
        if (timeout == null) {
            return DEFAULT_TIMEOUT;
        }
        if (timeout.isZero() || timeout.isNegative()) {
            return NO_TIMEOUT;
        }
        return timeout.compareTo(MINIMUM_TIMEOUT) > 0 ? timeout : MINIMUM_TIMEOUT;
    }
}

