/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;

public class GreedyCopySetRegionGroupAllocator
implements IRegionGroupAllocator {
    private static final Random RANDOM = new Random();
    private static final int GCR_MAX_OPTIMAL_PLAN_NUM = 100;
    private int replicationFactor;
    private int[] dataNodeIds;
    private int[] regionCounter;
    private int[] databaseRegionCounter;
    private int[][] combinationCounter;
    int optimalRegionSum;
    int optimalDatabaseRegionSum;
    int optimalCombinationSum;
    List<int[]> optimalReplicaSets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        try {
            this.prepare(replicationFactor, availableDataNodeMap, allocatedRegionGroups, databaseAllocatedRegionGroups);
            this.dfs(-1, 0, new int[replicationFactor], 0, 0);
            Collections.shuffle(this.optimalReplicaSets);
            int[] optimalReplicaSet = this.optimalReplicaSets.get(0);
            TRegionReplicaSet result = new TRegionReplicaSet();
            result.setRegionId(consensusGroupId);
            for (int i = 0; i < replicationFactor; ++i) {
                result.addToDataNodeLocations(availableDataNodeMap.get(optimalReplicaSet[i]).getLocation());
            }
            TRegionReplicaSet tRegionReplicaSet = result;
            return tRegionReplicaSet;
        }
        finally {
            this.clear();
        }
    }

    private void prepare(int replicationFactor, Map<Integer, TDataNodeConfiguration> availableDataNodeMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups) {
        List dataNodeLocations;
        this.replicationFactor = replicationFactor;
        int maxDataNodeId = Math.max(availableDataNodeMap.keySet().stream().max(Integer::compareTo).orElse(0), allocatedRegionGroups.stream().flatMap(regionGroup -> regionGroup.getDataNodeLocations().stream()).mapToInt(TDataNodeLocation::getDataNodeId).max().orElse(0));
        this.regionCounter = new int[maxDataNodeId + 1];
        Arrays.fill(this.regionCounter, 0);
        this.databaseRegionCounter = new int[maxDataNodeId + 1];
        Arrays.fill(this.databaseRegionCounter, 0);
        this.combinationCounter = new int[maxDataNodeId + 1][maxDataNodeId + 1];
        for (int i = 0; i <= maxDataNodeId; ++i) {
            Arrays.fill(this.combinationCounter[i], 0);
        }
        for (TRegionReplicaSet regionReplicaSet : allocatedRegionGroups) {
            dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (int i = 0; i < dataNodeLocations.size(); ++i) {
                int n = ((TDataNodeLocation)dataNodeLocations.get(i)).getDataNodeId();
                this.regionCounter[n] = this.regionCounter[n] + 1;
                for (int j = i + 1; j < dataNodeLocations.size(); ++j) {
                    int[] nArray = this.combinationCounter[((TDataNodeLocation)dataNodeLocations.get(i)).getDataNodeId()];
                    int n2 = ((TDataNodeLocation)dataNodeLocations.get(j)).getDataNodeId();
                    nArray[n2] = nArray[n2] + 1;
                    int[] nArray2 = this.combinationCounter[((TDataNodeLocation)dataNodeLocations.get(j)).getDataNodeId()];
                    int n3 = ((TDataNodeLocation)dataNodeLocations.get(i)).getDataNodeId();
                    nArray2[n3] = nArray2[n3] + 1;
                }
            }
        }
        for (TRegionReplicaSet regionReplicaSet : databaseAllocatedRegionGroups) {
            dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (TDataNodeLocation dataNodeLocation : dataNodeLocations) {
                int n = dataNodeLocation.getDataNodeId();
                this.databaseRegionCounter[n] = this.databaseRegionCounter[n] + 1;
            }
        }
        HashMap dataNodeEntryMap = new HashMap(maxDataNodeId + 1);
        availableDataNodeMap.keySet().forEach(dataNodeId -> {
            int scatterWidth = 0;
            for (int j = 0; j <= maxDataNodeId; ++j) {
                if (this.combinationCounter[dataNodeId][j] <= 0) continue;
                ++scatterWidth;
            }
            dataNodeEntryMap.put(dataNodeId, new DataNodeEntry(this.databaseRegionCounter[dataNodeId], this.regionCounter[dataNodeId], scatterWidth));
        });
        this.dataNodeIds = dataNodeEntryMap.entrySet().stream().sorted(Map.Entry.comparingByValue(DataNodeEntry::compare)).map(Map.Entry::getKey).collect(Collectors.toList()).stream().mapToInt(Integer::intValue).toArray();
        this.optimalDatabaseRegionSum = Integer.MAX_VALUE;
        this.optimalRegionSum = Integer.MAX_VALUE;
        this.optimalCombinationSum = Integer.MAX_VALUE;
        this.optimalReplicaSets = new ArrayList<int[]>();
    }

    private void dfs(int lastIndex, int currentReplica, int[] currentReplicaSet, int databaseRegionSum, int regionSum) {
        if (regionSum > this.optimalRegionSum) {
            return;
        }
        if (regionSum == this.optimalRegionSum && databaseRegionSum > this.optimalDatabaseRegionSum) {
            return;
        }
        if (currentReplica == this.replicationFactor) {
            int combinationSum = 0;
            for (int i = 0; i < this.replicationFactor; ++i) {
                for (int j = i + 1; j < this.replicationFactor; ++j) {
                    combinationSum += this.combinationCounter[currentReplicaSet[i]][currentReplicaSet[j]];
                }
            }
            if (regionSum == this.optimalRegionSum && databaseRegionSum == this.optimalDatabaseRegionSum && combinationSum > this.optimalCombinationSum) {
                return;
            }
            if (regionSum < this.optimalRegionSum || databaseRegionSum < this.optimalDatabaseRegionSum || combinationSum < this.optimalCombinationSum) {
                this.optimalDatabaseRegionSum = databaseRegionSum;
                this.optimalRegionSum = regionSum;
                this.optimalCombinationSum = combinationSum;
                this.optimalReplicaSets.clear();
            }
            this.optimalReplicaSets.add(Arrays.copyOf(currentReplicaSet, this.replicationFactor));
            return;
        }
        for (int i = lastIndex + 1; i < this.dataNodeIds.length; ++i) {
            currentReplicaSet[currentReplica] = this.dataNodeIds[i];
            this.dfs(i, currentReplica + 1, currentReplicaSet, databaseRegionSum + this.databaseRegionCounter[this.dataNodeIds[i]], regionSum + this.regionCounter[this.dataNodeIds[i]]);
            if (this.optimalReplicaSets.size() != 100) continue;
            return;
        }
    }

    void clear() {
        this.optimalReplicaSets.clear();
    }

    private static class DataNodeEntry {
        private final int regionCount;
        private final int databaseRegionCount;
        private final int scatterWidth;
        private final int randomWeight;

        public DataNodeEntry(int databaseRegionCount, int regionCount, int scatterWidth) {
            this.databaseRegionCount = databaseRegionCount;
            this.regionCount = regionCount;
            this.scatterWidth = scatterWidth;
            this.randomWeight = RANDOM.nextInt();
        }

        public int compare(DataNodeEntry e) {
            return this.regionCount != e.regionCount ? Integer.compare(this.regionCount, e.regionCount) : (this.databaseRegionCount != e.databaseRegionCount ? Integer.compare(this.databaseRegionCount, e.databaseRegionCount) : (this.scatterWidth != e.scatterWidth ? Integer.compare(this.scatterWidth, e.scatterWidth) : Integer.compare(this.randomWeight, e.randomWeight)));
        }
    }
}

