/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.primitive.DoubleShortMaps;
import org.eclipse.collections.api.factory.primitive.ShortDoubleMaps;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.map.primitive.DoubleShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleShortMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortDoubleMap;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.primitive.DoubleShortPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableDoubleMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedDoubleShortMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableDoubleShortMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class DoubleShortHashMap
extends AbstractMutableShortValuesMap
implements MutableDoubleShortMap,
Externalizable,
MutableDoubleKeysMap {
    private static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableShortValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public DoubleShortHashMap() {
        this.allocateTable(16);
    }

    public DoubleShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public DoubleShortHashMap(DoubleShortMap map) {
        if (map instanceof DoubleShortHashMap && ((DoubleShortHashMap)map).occupiedWithSentinels == 0) {
            DoubleShortHashMap hashMap = (DoubleShortHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1) {
        return new DoubleShortHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1, double key2, short value2) {
        return new DoubleShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1, double key2, short value2, double key3, short value3) {
        return new DoubleShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1, double key2, short value2, double key3, short value3, double key4, short value4) {
        return new DoubleShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected short getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected short getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleShortMap)) {
            return false;
        }
        DoubleShortMap other = (DoubleShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0.0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1.0).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, (short)0);
    }

    @Override
    public void put(double key, short value) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, key) == 0) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(DoubleShortMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(DoubleShortToShortFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(double key) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(double key) {
        this.removeKey(key);
    }

    @Override
    public short removeKeyIfAbsent(double key, short value) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            short oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public short getIfAbsentPut(double key, short value) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public short getAndPut(double key, short putValue, short defaultValue) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                short existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                short existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            short existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public short getIfAbsentPut(double key, ShortFunction0 function) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> short getIfAbsentPutWith(double key, ShortFunction<? super P> function, P parameter) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public short getIfAbsentPutWithKey(double key, DoubleToShortFunction function) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public short addToValue(double key, short toBeAdded) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(double key, short value, int index) {
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1.0;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        double[] copy = new double[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public short updateValue(double key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public DoubleShortHashMap withKeyValue(double key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleShortHashMap withKeysValues(double key1, short value1, double key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleShortHashMap withKeysValues(double key1, short value1, double key2, short value2, double key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleShortHashMap withKeysValues(double key1, short value1, double key2, short value2, double key3, short value3, double key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public DoubleShortHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public DoubleShortHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    @Override
    public MutableDoubleShortMap asUnmodifiable() {
        return new UnmodifiableDoubleShortMap(this);
    }

    @Override
    public MutableDoubleShortMap asSynchronized() {
        return new SynchronizedDoubleShortMap(this);
    }

    @Override
    public ImmutableDoubleShortMap toImmutable() {
        return DoubleShortMaps.immutable.ofAll(this);
    }

    @Override
    public short get(double key) {
        return this.getIfAbsent(key, (short)0);
    }

    @Override
    public short getIfAbsent(double key, short ifAbsent) {
        if (DoubleShortHashMap.isEmptyKey(key) || DoubleShortHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private short getForSentinel(double key, short ifAbsent) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private short slowGetIfAbsent(double key, short ifAbsent) {
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private short fastGetIfAbsent(double key, short ifAbsent) {
        int index = this.mask((int)key);
        for (int i = 0; i < 4; ++i) {
            double keyAtIndex = this.keys[index];
            if (Double.compare(keyAtIndex, key) == 0) {
                return this.values[index];
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private short slowGetIfAbsentTwo(double key, short ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public short getOrThrow(double key) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(double key) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(DoubleShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<DoubleShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableShortDoubleMap flipUniqueValues() {
        MutableShortDoubleMap result = ShortDoubleMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    @Override
    public DoubleShortHashMap select(DoubleShortPredicate predicate) {
        DoubleShortHashMap result = new DoubleShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public DoubleShortHashMap reject(DoubleShortPredicate predicate) {
        DoubleShortHashMap result = new DoubleShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readShort());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.mask((int)element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(double element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            double keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(double element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.doubleSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
        double keyAtIndex;
        while (Double.compare(keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleShortHashMap.isEmptyKey(key) && !DoubleShortHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !DoubleShortHashMap.isEmptyKey(this.keys[index]) && !DoubleShortHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    @Override
    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ double[] access$302(DoubleShortHashMap x0, double[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$502(DoubleShortHashMap x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<DoubleShortPair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super DoubleShortPair> procedure) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.zeroValue));
                }
                if (((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(DoubleShortHashMap.this.keys[i], DoubleShortHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super DoubleShortPair> objectIntProcedure) {
            int index = 0;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(DoubleShortHashMap.this.keys[i], DoubleShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super DoubleShortPair, ? super P> procedure, P parameter) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(DoubleShortHashMap.this.keys[i], DoubleShortHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<DoubleShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<DoubleShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public DoubleShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (DoubleShortHashMap.this.containsKey(0.0)) {
                        return PrimitiveTuples.pair(0.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (DoubleShortHashMap.this.containsKey(1.0)) {
                        return PrimitiveTuples.pair(1.0, ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.oneValue);
                    }
                }
                double[] keys = DoubleShortHashMap.this.keys;
                while (!DoubleShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                DoubleShortPair result = PrimitiveTuples.pair(keys[this.position], DoubleShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != DoubleShortHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableShortValuesMap.AbstractShortValuesCollection {
        private ValuesCollection() {
        }

        @Override
        public MutableShortIterator shortIterator() {
            return DoubleShortHashMap.this.shortIterator();
        }

        @Override
        public boolean remove(short item) {
            int oldSize = DoubleShortHashMap.this.size();
            if (DoubleShortHashMap.this.sentinelValues != null && ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsZeroKey && item == ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.zeroValue) {
                DoubleShortHashMap.this.removeKey(0.0);
            }
            if (DoubleShortHashMap.this.sentinelValues != null && ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsOneKey && item == ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.oneValue) {
                DoubleShortHashMap.this.removeKey(1.0);
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i]) || item != DoubleShortHashMap.this.values[i]) continue;
                DoubleShortHashMap.this.removeKey(DoubleShortHashMap.this.keys[i]);
            }
            return oldSize != DoubleShortHashMap.this.size();
        }

        @Override
        public boolean retainAll(ShortIterable source) {
            int oldSize = DoubleShortHashMap.this.size();
            ShortSet sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            DoubleShortHashMap retained = DoubleShortHashMap.this.select((double key, short value) -> sourceSet.contains(value));
            if (retained.size() != oldSize) {
                DoubleShortHashMap.access$302(DoubleShortHashMap.this, retained.keys);
                DoubleShortHashMap.access$502(DoubleShortHashMap.this, retained.values);
                DoubleShortHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public MutableShortCollection newEmpty() {
            return new ShortHashBag();
        }
    }

    private class KeySet
    extends AbstractMutableDoubleKeySet {
        private KeySet() {
        }

        @Override
        protected MutableDoubleKeysMap getOuter() {
            return DoubleShortHashMap.this;
        }

        @Override
        protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
            return DoubleShortHashMap.this.sentinelValues;
        }

        @Override
        protected double getKeyAtIndex(int index) {
            return DoubleShortHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return DoubleShortHashMap.this.keys.length;
        }

        @Override
        public MutableDoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean retainAll(DoubleIterable source) {
            int oldSize = DoubleShortHashMap.this.size();
            DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleShortHashMap retained = DoubleShortHashMap.this.select((double key, short value) -> sourceSet.contains(key));
            if (retained.size() != oldSize) {
                DoubleShortHashMap.access$302(DoubleShortHashMap.this, retained.keys);
                DoubleShortHashMap.access$502(DoubleShortHashMap.this, retained.values);
                DoubleShortHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(double ... source) {
            return this.retainAll(DoubleHashSet.newSetWith(source));
        }

        @Override
        public DoubleSet freeze() {
            DoubleShortHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                containsZeroKey = ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((DoubleShortHashMap)DoubleShortHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableDoubleMapKeySet(DoubleShortHashMap.this.keys, DoubleShortHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public MutableDoubleSet newEmpty() {
            return new DoubleHashSet();
        }
    }

    private class KeySetIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < DoubleShortHashMap.this.size();
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleShortHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleShortHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return this.lastKey;
                }
            }
            double[] keys = DoubleShortHashMap.this.keys;
            while (!DoubleShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyDoubleIterable {
        private KeysView() {
        }

        @Override
        public DoubleIterator doubleIterator() {
            return new UnmodifiableDoubleIterator(new KeySetIterator());
        }

        @Override
        public void each(DoubleProcedure procedure) {
            DoubleShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalShortIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < DoubleShortHashMap.this.size();
        }

        @Override
        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleShortHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return DoubleShortHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleShortHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return DoubleShortHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleShortHashMap.this.keys;
            while (!DoubleShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            short result = DoubleShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

