/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.tsfile.block.column.Column;

public abstract class Transformer
implements LayerReader {
    protected Column[] cachedColumns;
    protected int cacheConsumed;

    protected Transformer() {
    }

    @Override
    public final YieldableState yield() throws Exception {
        if (this.cachedColumns != null && this.cacheConsumed < this.cachedColumns[0].getPositionCount()) {
            return YieldableState.YIELDABLE;
        }
        return this.yieldValue();
    }

    @Override
    public void consumedAll() {
        this.invalidCache();
    }

    @Override
    public Column[] current() {
        if (this.cacheConsumed == 0) {
            return this.cachedColumns;
        }
        Column[] ret = new Column[this.cachedColumns.length];
        for (int i = 0; i < this.cachedColumns.length; ++i) {
            ret[i] = this.cachedColumns[i].subColumn(this.cacheConsumed);
        }
        return ret;
    }

    private void invalidCache() {
        this.cacheConsumed = 0;
        this.cachedColumns = null;
    }

    protected abstract YieldableState yieldValue() throws Exception;
}

