/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainEncoder
extends Encoder {
    private static final Logger logger = LoggerFactory.getLogger(PlainEncoder.class);
    private TSDataType dataType;
    private int maxStringLength;

    public PlainEncoder(TSDataType dataType, int maxStringLength) {
        super(TSEncoding.PLAIN);
        this.dataType = dataType;
        this.maxStringLength = maxStringLength;
    }

    @Override
    public void encode(boolean value, ByteArrayOutputStream out) {
        if (value) {
            out.write(1);
        } else {
            out.write(0);
        }
    }

    @Override
    public void encode(short value, ByteArrayOutputStream out) {
        out.write(value >> 8 & 0xFF);
        out.write(value & 0xFF);
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        ReadWriteForEncodingUtils.writeVarInt(value, out);
    }

    @Override
    public void encode(long value, ByteArrayOutputStream out) {
        for (int i = 7; i >= 0; --i) {
            out.write((byte)(value >> i * 8 & 0xFFL));
        }
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        int floatInt = Float.floatToIntBits(value);
        out.write(floatInt >> 24 & 0xFF);
        out.write(floatInt >> 16 & 0xFF);
        out.write(floatInt >> 8 & 0xFF);
        out.write(floatInt & 0xFF);
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        this.encode(Double.doubleToLongBits(value), out);
    }

    @Override
    public void encode(Binary value, ByteArrayOutputStream out) {
        try {
            this.encode(value.getLength(), out);
            out.write(value.getValues());
        }
        catch (IOException e) {
            logger.error("tsfile-encoding PlainEncoder: error occurs when encode Binary value {}", (Object)value, (Object)e);
        }
    }

    @Override
    public void encode(BigDecimal value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("tsfile-encoding PlainEncoder: current version does not support BigDecimal value encoding");
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
    }

    @Override
    public int getOneItemMaxSize() {
        switch (this.dataType) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case DATE: {
                return 4;
            }
            case INT64: 
            case TIMESTAMP: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return 4 + 4 * this.maxStringLength;
            }
        }
        throw new UnsupportedOperationException(this.dataType.toString());
    }

    @Override
    public long getMaxByteSize() {
        return 0L;
    }
}

