/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.transport;

public enum TransportProfile {
    TCP_UASC_UABINARY,
    HTTPS_UABINARY,
    HTTPS_UAXML,
    HTTPS_UAJSON,
    WSS_UASC_UABINARY,
    WSS_UAJSON;


    public static TransportProfile fromUri(String uri) {
        switch (uri) {
            case "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary": {
                return TCP_UASC_UABINARY;
            }
            case "http://opcfoundation.org/UA-Profile/Transport/https-uabinary": {
                return HTTPS_UABINARY;
            }
            case "http://opcfoundation.org/UA-Profile/Transport/https-uasoapxml": {
                return HTTPS_UAXML;
            }
            case "http://opcfoundation.org/UA-Profile/Transport/https-uajson": {
                return HTTPS_UAJSON;
            }
            case "http://opcfoundation.org/UA-Profile/Transport/wss-uasc-uabinary": {
                return WSS_UASC_UABINARY;
            }
            case "http://opcfoundation.org/UA-Profile/Transport/wss-uajson": {
                return WSS_UAJSON;
            }
        }
        throw new IllegalArgumentException("unknown transport: " + uri);
    }

    public String getUri() {
        switch (this) {
            case TCP_UASC_UABINARY: {
                return "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
            }
            case HTTPS_UABINARY: {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            case HTTPS_UAXML: {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uasoapxml";
            }
            case HTTPS_UAJSON: {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uajson";
            }
            case WSS_UASC_UABINARY: {
                return "http://opcfoundation.org/UA-Profile/Transport/wss-uasc-uabinary";
            }
            case WSS_UAJSON: {
                return "http://opcfoundation.org/UA-Profile/Transport/wss-uajson";
            }
        }
        throw new IllegalArgumentException("unhandled profile: " + (Object)((Object)this));
    }

    public String getScheme() {
        switch (this) {
            case TCP_UASC_UABINARY: {
                return "opc.tcp";
            }
            case HTTPS_UABINARY: 
            case HTTPS_UAXML: 
            case HTTPS_UAJSON: {
                return "https";
            }
            case WSS_UASC_UABINARY: 
            case WSS_UAJSON: {
                return "opc.wss";
            }
        }
        throw new IllegalArgumentException("unhandled profile: " + (Object)((Object)this));
    }
}

