/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatistic;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatisticTool;

class PrintUtil {
    static String[] header_1 = new String[]{"", "Total", "Overlap", "Overlap/Total"};
    static String[] header_2 = new String[]{"", "Total", "Sequence", "UnSequence", "UnSequence/Total"};
    static long MSize = 0x100000L;

    PrintUtil() {
    }

    public static void printOneStatistics(OverlapStatistic overlapStatistic, String label) {
        System.out.println();
        PrintUtil.printTableLog(overlapStatistic);
        PrintUtil.printProgressLog(label, overlapStatistic);
    }

    private static void printProgressLog(String label, OverlapStatistic statistic) {
        String[][] log = new String[][]{{"File Number", statistic.totalSequenceFile + statistic.totalUnsequenceFile + "", statistic.totalSequenceFile + "", statistic.totalUnsequenceFile + "", String.format("%.2f%%", (double)statistic.totalUnsequenceFile * 100.0 / (double)(statistic.totalSequenceFile + statistic.totalUnsequenceFile))}, {"File Size(MB)", (statistic.totalSequenceFileSize + statistic.totalUnsequenceFileSize) / MSize + "", statistic.totalSequenceFileSize / MSize + "", statistic.totalUnsequenceFileSize / MSize + "", String.format("%.2f%%", (double)statistic.totalUnsequenceFileSize * 100.0 / (double)(statistic.totalSequenceFileSize + statistic.totalUnsequenceFileSize))}, {"Duration", Math.max(statistic.sequenceMaxEndTime, statistic.unSequenceMaxEndTime) - Math.min(statistic.sequenceMinStartTime, statistic.unSequenceMinStartTime) + "", statistic.sequenceMaxEndTime - statistic.sequenceMinStartTime + "", statistic.unSequenceMaxEndTime - statistic.unSequenceMinStartTime + "", String.format("%.2f%%", (double)(statistic.unSequenceMaxEndTime - statistic.unSequenceMinStartTime) * 100.0 / (double)(Math.max(statistic.sequenceMaxEndTime, statistic.unSequenceMaxEndTime) - Math.min(statistic.sequenceMinStartTime, statistic.unSequenceMinStartTime)))}};
        System.out.println(System.getProperty("line.separator") + "Data Table:");
        PrintUtil.printStaticsTable(log);
        System.out.printf("Progress: %s\nSequence File progress: %d/%d\nPartition progress: %d/%d %s", label, OverlapStatisticTool.processedSeqFileCount, OverlapStatisticTool.seqFileCount, OverlapStatisticTool.processedTimePartitionCount, OverlapStatisticTool.timePartitionFileMap.size(), System.getProperty("line.separator"));
    }

    private static void printTableLog(OverlapStatistic overlapStatistic) {
        double overlappedSeqFilePercentage = PrintUtil.calculatePercentage(overlapStatistic.overlappedSequenceFiles, overlapStatistic.totalSequenceFile);
        double overlappedChunkGroupPercentage = PrintUtil.calculatePercentage(overlapStatistic.overlappedChunkGroupsInSequenceFile, overlapStatistic.totalChunkGroupsInSequenceFile);
        double overlappedChunkPercentage = PrintUtil.calculatePercentage(overlapStatistic.overlappedChunksInSequenceFile, overlapStatistic.totalChunksInSequenceFile);
        String[][] log = new String[][]{{"Sequence File", overlapStatistic.totalSequenceFile + "", overlapStatistic.overlappedSequenceFiles + "", String.format("%.2f%%", overlappedSeqFilePercentage)}, {"ChunkGroup In Sequence File", overlapStatistic.totalChunkGroupsInSequenceFile + "", overlapStatistic.overlappedChunkGroupsInSequenceFile + "", String.format("%.2f%%", overlappedChunkGroupPercentage)}, {"Chunk In Sequence File", overlapStatistic.totalChunksInSequenceFile + "", overlapStatistic.overlappedChunksInSequenceFile + "", String.format("%.2f%%", overlappedChunkPercentage)}};
        System.out.println("Overlap Table:");
        PrintUtil.printOverlapTable(log);
    }

    private static double calculatePercentage(long numerator, long denominator) {
        return denominator != 0L ? (double)numerator / (double)denominator * 100.0 : 0.0;
    }

    public static void printOverlapTable(String[][] data) {
        int numRows = data.length;
        int[] maxCellWidths = PrintUtil.calculateMaxCellWidths(header_1, data);
        PrintUtil.printTopBorder(maxCellWidths);
        PrintUtil.printRow(header_1, maxCellWidths);
        for (int row = 0; row < numRows; ++row) {
            PrintUtil.printSeparator(maxCellWidths);
            PrintUtil.printRow(data[row], maxCellWidths);
        }
        PrintUtil.printBottomBorder(maxCellWidths);
    }

    public static void printStaticsTable(String[][] data) {
        int numRows = data.length;
        int[] maxCellWidths = PrintUtil.calculateMaxCellWidths(header_2, data);
        PrintUtil.printTopBorder(maxCellWidths);
        PrintUtil.printRow(header_2, maxCellWidths);
        for (int row = 0; row < numRows; ++row) {
            PrintUtil.printSeparator(maxCellWidths);
            PrintUtil.printRow(data[row], maxCellWidths);
        }
        PrintUtil.printBottomBorder(maxCellWidths);
    }

    private static int[] calculateMaxCellWidths(String[] header, String[][] data) {
        int numCols = header.length;
        int[] maxCellWidths = new int[numCols];
        for (int col = 0; col < numCols; ++col) {
            maxCellWidths[col] = header[col].length();
            for (String[] row : data) {
                maxCellWidths[col] = Math.max(maxCellWidths[col], row[col].length());
            }
        }
        return maxCellWidths;
    }

    private static void printTopBorder(int[] maxCellWidths) {
        System.out.print("\u250c");
        for (int width : maxCellWidths) {
            PrintUtil.printRepeat("\u2500", width + 2);
            System.out.print("\u252c");
        }
        System.out.println();
    }

    private static void printSeparator(int[] maxCellWidths) {
        System.out.print("\u251c");
        for (int width : maxCellWidths) {
            PrintUtil.printRepeat("\u2500", width + 2);
            System.out.print("\u253c");
        }
        System.out.println();
    }

    private static void printBottomBorder(int[] maxCellWidths) {
        System.out.print("\u2514");
        for (int width : maxCellWidths) {
            PrintUtil.printRepeat("\u2500", width + 2);
            System.out.print("\u2534");
        }
        System.out.println();
    }

    private static void printRow(String[] row, int[] maxCellWidths) {
        for (int col = 0; col < row.length; ++col) {
            System.out.printf("\u2502 %-" + maxCellWidths[col] + "s ", row[col]);
        }
        System.out.println("\u2502");
    }

    private static void printRepeat(String value, int times) {
        for (int i = 0; i < times; ++i) {
            System.out.print(value);
        }
    }
}

