/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.AbstractOperator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.read.common.block.TsBlock;

public abstract class AbstractConsumeAllOperator
extends AbstractOperator
implements ProcessOperator {
    protected final List<Operator> children;
    protected final int inputOperatorsCount;
    protected TsBlock[] inputTsBlocks;
    protected final boolean[] canCallNext;
    protected int readyChildIndex;
    protected int currentChildIndex = 0;
    protected boolean hasEmptyChildInput = false;

    protected AbstractConsumeAllOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.canCallNext = new boolean[this.inputOperatorsCount];
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.canCallNext[i] = false;
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        this.readyChildIndex = 0;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i) || this.children.get(i) == null) continue;
            ListenableFuture<?> blocked = this.children.get(i).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                this.readyChildIndex = i;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    protected boolean prepareInput() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && this.currentChildIndex < this.inputOperatorsCount) {
            if (this.canSkipCurrentChild(this.currentChildIndex)) {
                ++this.currentChildIndex;
                continue;
            }
            if (this.canCallNext[this.currentChildIndex]) {
                if (this.children.get(this.currentChildIndex).hasNextWithTimer()) {
                    this.inputTsBlocks[this.currentChildIndex] = this.getNextTsBlock(this.currentChildIndex);
                    this.canCallNext[this.currentChildIndex] = false;
                    if (this.isEmpty(this.currentChildIndex)) {
                        this.hasEmptyChildInput = true;
                    } else {
                        this.processCurrentInputTsBlock(this.currentChildIndex);
                    }
                } else {
                    this.handleFinishedChild(this.currentChildIndex);
                }
            } else {
                this.hasEmptyChildInput = true;
            }
            ++this.currentChildIndex;
        }
        if (this.currentChildIndex == this.inputOperatorsCount) {
            this.currentChildIndex = 0;
            if (!this.hasEmptyChildInput) {
                return true;
            }
            this.hasEmptyChildInput = false;
        }
        return false;
    }

    protected boolean isEmpty(int index) {
        return this.inputTsBlocks[index] == null || this.inputTsBlocks[index].isEmpty();
    }

    protected boolean canSkipCurrentChild(int currentChildIndex) {
        return !this.isEmpty(currentChildIndex) || this.children.get(currentChildIndex) == null;
    }

    protected void processCurrentInputTsBlock(int currentInputIndex) {
    }

    protected void handleFinishedChild(int currentChildIndex) throws Exception {
        this.children.get(currentChildIndex).close();
        this.children.set(currentChildIndex, null);
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            if (child == null) continue;
            child.close();
        }
        this.inputTsBlocks = null;
    }

    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        return this.children.get(childIndex).nextWithTimer();
    }
}

