/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.OptionalInt;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CanonicalizationAware;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;

public class ScopeAware<T extends Node> {
    private final Analysis analysis;
    private final Scope queryScope;
    private final T node;
    private final int hash;

    private ScopeAware(Analysis analysis, Scope scope, T node) {
        Objects.requireNonNull(scope, "scope is null");
        this.queryScope = scope.getQueryBoundaryScope();
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.node = (Node)Objects.requireNonNull(node, "node is null");
        this.hash = AstUtil.treeHash(node, this::scopeAwareHash);
    }

    public static <T extends Node> ScopeAware<T> scopeAwareKey(T node, Analysis analysis, Scope scope) {
        return new ScopeAware<T>(analysis, scope, node);
    }

    public T getNode() {
        return this.node;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeAware other = (ScopeAware)o;
        Preconditions.checkArgument((this.queryScope == other.queryScope ? 1 : 0) != 0, (Object)"Expressions must be in the same local scope");
        return AstUtil.treeEqual(this.node, other.node, this::scopeAwareComparison);
    }

    public String toString() {
        return "ScopeAware(" + this.node + ")";
    }

    private Boolean scopeAwareComparison(Node left, Node right) {
        if (left instanceof Expression && right instanceof Expression) {
            Expression leftExpression = (Expression)left;
            Expression rightExpression = (Expression)right;
            if (this.analysis.isColumnReference(leftExpression) && this.analysis.isColumnReference(rightExpression)) {
                ResolvedField leftField = this.analysis.getResolvedField(leftExpression);
                ResolvedField rightField = this.analysis.getResolvedField(rightExpression);
                boolean leftFieldInSubqueryScope = leftField.getScope().hasOuterParent(this.queryScope);
                boolean rightFieldInSubqueryScope = rightField.getScope().hasOuterParent(this.queryScope);
                if (leftFieldInSubqueryScope && rightFieldInSubqueryScope) {
                    return AstUtil.treeEqual(leftExpression, rightExpression, CanonicalizationAware::canonicalizationAwareComparison);
                }
                if (!leftFieldInSubqueryScope && !rightFieldInSubqueryScope) {
                    return leftField.getFieldId().equals(rightField.getFieldId());
                }
                return false;
            }
            if (leftExpression instanceof Identifier && rightExpression instanceof Identifier) {
                return AstUtil.treeEqual(leftExpression, rightExpression, CanonicalizationAware::canonicalizationAwareComparison);
            }
        }
        if (!left.shallowEquals(right)) {
            return false;
        }
        return null;
    }

    private OptionalInt scopeAwareHash(Node node) {
        if (node instanceof Expression) {
            Expression expression = (Expression)node;
            if (this.analysis.isColumnReference(expression)) {
                ResolvedField field = this.analysis.getResolvedField(expression);
                Scope resolvedScope = field.getScope();
                if (resolvedScope.hasOuterParent(this.queryScope)) {
                    return OptionalInt.of(AstUtil.treeHash(expression, CanonicalizationAware::canonicalizationAwareHash));
                }
                return OptionalInt.of(field.getFieldId().hashCode());
            }
            if (expression instanceof Identifier) {
                return OptionalInt.of(AstUtil.treeHash(expression, CanonicalizationAware::canonicalizationAwareHash));
            }
            if (node.getChildren().isEmpty()) {
                return OptionalInt.of(expression.hashCode());
            }
        }
        return OptionalInt.empty();
    }
}

