/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.relational.execution.querystats.PlanOptimizersStatsCollector;
import org.apache.iotdb.db.queryengine.plan.relational.execution.querystats.QueryPlanOptimizerStatistics;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.GroupReference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Memo;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.RuleIndex;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.RuleStatsRecorder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.AdaptivePlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Match;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterativeOptimizer
implements AdaptivePlanOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(IterativeOptimizer.class);
    private final RuleStatsRecorder stats;
    private final List<PlanOptimizer> legacyRules;
    private final Set<Rule<?>> rules;
    private final RuleIndex ruleIndex;
    private final Predicate<Session> useLegacyRules;
    private final PlannerContext plannerContext;

    public IterativeOptimizer(PlannerContext plannerContext, RuleStatsRecorder stats, Set<Rule<?>> rules) {
        this(plannerContext, stats, session -> false, (List<PlanOptimizer>)ImmutableList.of(), rules);
    }

    public IterativeOptimizer(PlannerContext plannerContext, RuleStatsRecorder stats, Predicate<Session> useLegacyRules, List<PlanOptimizer> legacyRules, Set<Rule<?>> newRules) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.useLegacyRules = Objects.requireNonNull(useLegacyRules, "useLegacyRules is null");
        this.rules = Objects.requireNonNull(newRules, "rules is null");
        this.legacyRules = ImmutableList.copyOf(legacyRules);
        this.ruleIndex = RuleIndex.builder().register(newRules).build();
        stats.registerAll(newRules);
    }

    @Override
    public AdaptivePlanOptimizer.Result optimizeAndMarkPlanChanges(PlanNode plan, PlanOptimizer.Context context) {
        HashSet<PlanNodeId> changedPlanNodeIds = new HashSet<PlanNodeId>();
        Memo memo = new Memo(context.idAllocator(), plan);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve((GroupReference)planNode)));
        Duration timeout = new Duration(3.0, TimeUnit.MINUTES);
        Context optimizerContext = new Context(memo, lookup, context.idAllocator(), context.getSymbolAllocator(), System.nanoTime(), timeout.toMillis(), context.sessionInfo(), context.warningCollector());
        this.exploreGroup(memo.getRootGroup(), optimizerContext, changedPlanNodeIds);
        context.planOptimizersStatsCollector().add(optimizerContext.getIterativeOptimizerStatsCollector());
        return new AdaptivePlanOptimizer.Result(memo.extract(), (Set<PlanNodeId>)ImmutableSet.copyOf(changedPlanNodeIds));
    }

    public Set<Rule<?>> getRules() {
        return this.rules;
    }

    private boolean exploreGroup(int group, Context context, Set<PlanNodeId> changedPlanNodeIds) {
        boolean progress = this.exploreNode(group, context, changedPlanNodeIds);
        while (this.exploreChildren(group, context, changedPlanNodeIds)) {
            progress = true;
            if (this.exploreNode(group, context, changedPlanNodeIds)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context, Set<PlanNodeId> changedPlanNodeIds) {
        PlanNode node = context.memo.getNode(group);
        boolean done = false;
        boolean progress = false;
        while (!done) {
            context.checkTimeoutNotExhausted();
            done = true;
            Iterator possiblyMatchingRules = this.ruleIndex.getCandidates(node).iterator();
            while (possiblyMatchingRules.hasNext()) {
                long timeEnd;
                Rule rule = (Rule)possiblyMatchingRules.next();
                long timeStart = System.nanoTime();
                boolean invoked = false;
                boolean applied = false;
                if (rule.isEnabled(context.sessionInfo)) {
                    invoked = true;
                    Rule.Result result = this.transform(node, rule, context);
                    timeEnd = System.nanoTime();
                    if (result.getTransformedPlan().isPresent()) {
                        changedPlanNodeIds.add(result.getTransformedPlan().get().getPlanNodeId());
                    }
                    if (result.getTransformedPlan().isPresent()) {
                        node = context.memo.replace(group, result.getTransformedPlan().get(), rule.getClass().getName());
                        applied = true;
                        done = false;
                        progress = true;
                    }
                } else {
                    timeEnd = System.nanoTime();
                }
                context.recordRuleInvocation(rule, invoked, applied, timeEnd - timeStart);
            }
        }
        return progress;
    }

    private <T> Rule.Result transform(PlanNode node, Rule<T> rule, Context context) {
        Capture nodeCapture = Capture.newCapture();
        Pattern<T> pattern = rule.getPattern().capturedAs(nodeCapture);
        Iterator matches = pattern.match(node, context.lookup).iterator();
        while (matches.hasNext()) {
            long duration;
            Rule.Result result;
            Match match = (Match)matches.next();
            try {
                long start = System.nanoTime();
                result = rule.apply(match.capture(nodeCapture), match.captures(), this.ruleContext(context));
                if (LOG.isDebugEnabled() && !result.isEmpty()) {
                    LOG.debug("Rule: %s\nBefore:\n%s\nAfter:\n%s", new Object[]{rule.getClass().getName(), "", ""});
                }
                duration = System.nanoTime() - start;
            }
            catch (RuntimeException e) {
                this.stats.recordFailure(rule);
                context.iterativeOptimizerStatsCollector.recordFailure(rule);
                throw e;
            }
            this.stats.record(rule, duration, !result.isEmpty());
            if (!result.getTransformedPlan().isPresent()) continue;
            return result;
        }
        return Rule.Result.empty();
    }

    private boolean exploreChildren(int group, Context context, Set<PlanNodeId> changedPlanNodeIds) {
        boolean progress = false;
        PlanNode expression = context.memo.getNode(group);
        for (PlanNode child : expression.getChildren()) {
            Preconditions.checkArgument((boolean)(child instanceof GroupReference), (Object)("Expected child to be a group reference. Found: " + child.getClass().getName()));
            if (!this.exploreGroup(((GroupReference)child).getGroupId(), context, changedPlanNodeIds)) continue;
            progress = true;
        }
        return progress;
    }

    private Rule.Context ruleContext(final Context context) {
        return new Rule.Context(){

            @Override
            public Lookup getLookup() {
                return context.lookup;
            }

            @Override
            public QueryId getIdAllocator() {
                return context.idAllocator;
            }

            @Override
            public SymbolAllocator getSymbolAllocator() {
                return context.symbolAllocator;
            }

            @Override
            public SessionInfo getSessionInfo() {
                return context.sessionInfo;
            }

            @Override
            public void checkTimeoutNotExhausted() {
                context.checkTimeoutNotExhausted();
            }

            @Override
            public WarningCollector getWarningCollector() {
                return context.warningCollector;
            }
        };
    }

    private static class Context {
        private final Memo memo;
        private final Lookup lookup;
        private final QueryId idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final long startTimeInNanos;
        private final long timeoutInMilliseconds;
        private final SessionInfo sessionInfo;
        private final WarningCollector warningCollector;
        private final PlanOptimizersStatsCollector iterativeOptimizerStatsCollector;

        public Context(Memo memo, Lookup lookup, QueryId idAllocator, SymbolAllocator symbolAllocator, long startTimeInNanos, long timeoutInMilliseconds, SessionInfo sessionInfo, WarningCollector warningCollector) {
            Preconditions.checkArgument((timeoutInMilliseconds >= 0L ? 1 : 0) != 0, (Object)"Timeout has to be a non-negative number [milliseconds]");
            this.memo = memo;
            this.lookup = lookup;
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.startTimeInNanos = startTimeInNanos;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.sessionInfo = sessionInfo;
            this.warningCollector = warningCollector;
            this.iterativeOptimizerStatsCollector = PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector();
        }

        public void checkTimeoutNotExhausted() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeInNanos) >= this.timeoutInMilliseconds) {
                String message = String.format(TSStatusCode.OPTIMIZER_TIMEOUT.getStatusCode() + ": The optimizer exhausted the time limit of %d ms", this.timeoutInMilliseconds);
                List<QueryPlanOptimizerStatistics> topRulesByTime = this.iterativeOptimizerStatsCollector.getTopRuleStats(5);
                message = topRulesByTime.isEmpty() ? message + ": no rules invoked" : message + ": Top rules: " + topRulesByTime.stream().map(ruleStats -> String.format("%s: %s ms, %s invocations, %s applications", ruleStats.rule(), TimeUnit.NANOSECONDS.toMillis(ruleStats.totalTime()), ruleStats.invocations(), ruleStats.applied())).collect(Collectors.joining(",\n\t\t", "{\n\t\t", " }"));
                throw new RuntimeException(message);
            }
        }

        public PlanOptimizersStatsCollector getIterativeOptimizerStatsCollector() {
            return this.iterativeOptimizerStatsCollector;
        }

        void recordRuleInvocation(Rule<?> rule, boolean invoked, boolean applied, long elapsedNanos) {
            this.iterativeOptimizerStatsCollector.recordRule(rule, invoked, applied, elapsedNanos);
        }
    }
}

