/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnMetadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadata;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.tsfile.read.common.type.Type;

public class MetadataUtil {
    private MetadataUtil() {
    }

    public static void checkTableName(String databaseName, Optional<String> tableName) {
        MetadataUtil.checkDatabaseName(databaseName);
        tableName.ifPresent(name -> MetadataUtil.checkLowerCase(name, "tableName"));
    }

    public static String checkDatabaseName(String databaseName) {
        return MetadataUtil.checkLowerCase(databaseName, "databaseName");
    }

    public static String checkTableName(String tableName) {
        return MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static void checkObjectName(String dbName, String objectName) {
        MetadataUtil.checkLowerCase(dbName, "dbName");
        MetadataUtil.checkLowerCase(objectName, "objectName");
    }

    public static String checkLowerCase(String value, String name) {
        if (value == null) {
            throw new NullPointerException(String.format("%s is null", name));
        }
        Preconditions.checkArgument((boolean)value.equals(value.toLowerCase(Locale.ENGLISH)), (String)"%s is not lowercase: %s", (Object)name, (Object)value);
        return value;
    }

    public static QualifiedObjectName createQualifiedObjectName(SessionInfo session, QualifiedName name) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(name, "name is null");
        if (name.getParts().size() > 2) {
            throw new SemanticException(String.format("Too many dots in table name: %s", name));
        }
        List parts = Lists.reverse(name.getParts());
        String objectName = (String)parts.get(0);
        String databaseName = parts.size() > 1 ? (String)parts.get(1) : session.getDatabaseName().orElseThrow(() -> new SemanticException("Database must be specified when session database is not set"));
        return new QualifiedObjectName(databaseName, objectName);
    }

    public static boolean tableExists(Metadata metadata, SessionInfo session, String table) {
        if (!session.getDatabaseName().isPresent()) {
            return false;
        }
        QualifiedObjectName name = new QualifiedObjectName(session.getDatabaseName().get(), table);
        return metadata.tableExists(name);
    }

    public static class TableMetadataBuilder {
        private final String tableName;
        private final ImmutableList.Builder<ColumnMetadata> columns = ImmutableList.builder();
        private final ImmutableMap.Builder<String, Object> properties = ImmutableMap.builder();
        private final Optional<String> comment;

        public static TableMetadataBuilder tableMetadataBuilder(String tableName) {
            return new TableMetadataBuilder(tableName);
        }

        private TableMetadataBuilder(String tableName) {
            this(tableName, Optional.empty());
        }

        private TableMetadataBuilder(String tableName, Optional<String> comment) {
            this.tableName = tableName;
            this.comment = comment;
        }

        public TableMetadataBuilder column(String columnName, Type type) {
            this.columns.add((Object)new ColumnMetadata(columnName, type));
            return this;
        }

        public TableMetadataBuilder hiddenColumn(String columnName, Type type) {
            this.columns.add((Object)ColumnMetadata.builder().setName(columnName).setType(type).setHidden(true).build());
            return this;
        }

        public TableMetadataBuilder property(String name, Object value) {
            this.properties.put((Object)name, value);
            return this;
        }

        public TableMetadata build() {
            return new TableMetadata(this.tableName, (List<ColumnMetadata>)this.columns.build(), (Map<String, Object>)this.properties.buildOrThrow(), this.comment);
        }
    }
}

