/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Map;
import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionTreeRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public final class ExpressionSymbolInliner {
    private final Function<Symbol, Expression> mapping;

    public static Expression inlineSymbols(Map<Symbol, ? extends Expression> mapping, Expression expression) {
        return ExpressionSymbolInliner.inlineSymbols(mapping::get, expression);
    }

    public static Expression inlineSymbols(Function<Symbol, Expression> mapping, Expression expression) {
        return new ExpressionSymbolInliner(mapping).rewrite(expression);
    }

    private ExpressionSymbolInliner(Function<Symbol, Expression> mapping) {
        this.mapping = mapping;
    }

    private Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private class Visitor
    extends ExpressionRewriter<Void> {
        private final Multiset<String> excludedNames = HashMultiset.create();

        private Visitor() {
        }

        @Override
        public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.excludedNames.contains((Object)node.getName())) {
                return node;
            }
            Expression expression = (Expression)ExpressionSymbolInliner.this.mapping.apply(Symbol.from(node));
            Preconditions.checkArgument((expression != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
            return expression;
        }
    }
}

