/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.schema.MemUsageUtil;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.IDeviceAttributeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAttributeStore
implements IDeviceAttributeStore {
    private static final Logger logger = LoggerFactory.getLogger(DeviceAttributeStore.class);
    private static final long MAP_SIZE = RamUsageEstimator.shallowSizeOfInstance(HashMap.class);
    private final List<Map<String, Binary>> deviceAttributeList = new ArrayList<Map<String, Binary>>();
    private final MemSchemaRegionStatistics regionStatistics;

    public DeviceAttributeStore(MemSchemaRegionStatistics regionStatistics) {
        this.regionStatistics = regionStatistics;
    }

    @Override
    public void clear() {
        this.deviceAttributeList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean createSnapshot(File targetDir) {
        File snapshotTmp = SystemFileFactory.INSTANCE.getFile(targetDir, "device_attribute.snapshot.tmp");
        File snapshot = SystemFileFactory.INSTANCE.getFile(targetDir, "device_attribute.snapshot");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(snapshotTmp);
            BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
            try {
                this.serialize(outputStream);
            }
            finally {
                outputStream.flush();
                fileOutputStream.getFD().sync();
                outputStream.close();
            }
            if (snapshot.exists() && !FileUtils.deleteFileIfExist((File)snapshot)) {
                logger.error("Failed to delete old snapshot {} while creating device attribute snapshot.", (Object)snapshot.getName());
                boolean bl = false;
                return bl;
            }
            if (!snapshotTmp.renameTo(snapshot)) {
                logger.error("Failed to rename {} to {} while creating device attribute snapshot.", (Object)snapshotTmp.getName(), (Object)snapshot.getName());
                FileUtils.deleteFileIfExist((File)snapshot);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("Failed to create device attribute snapshot due to {}", (Object)e.getMessage(), (Object)e);
            FileUtils.deleteFileIfExist((File)snapshot);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteFileIfExist((File)snapshotTmp);
        }
    }

    @Override
    public void loadFromSnapshot(File snapshotDir) throws IOException {
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "device_attribute.snapshot");
        if (!snapshot.exists()) {
            logger.info("Device attribute snapshot {} not found, consider it as upgraded from the older version, use empty attributes", (Object)snapshot);
            return;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(snapshot.toPath(), new OpenOption[0]));){
            this.deserialize(inputStream);
        }
        catch (IOException e) {
            logger.warn("Load device attribute snapshot from {} failed", (Object)snapshotDir);
            throw e;
        }
    }

    @Override
    public synchronized int createAttribute(List<String> nameList, Object[] valueList, String tableName) {
        long memUsage = MAP_SIZE + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        HashMap<String, Binary> attributeMap = new HashMap<String, Binary>();
        for (int i = 0; i < nameList.size(); ++i) {
            Binary value = (Binary)valueList[i];
            if (valueList[i] == null) continue;
            attributeMap.put(nameList.get(i), value);
            memUsage += MemUsageUtil.computeKVMemUsageInMap((String)nameList.get(i), (Binary)value);
            this.addTableAttributeMemory(tableName, value.ramBytesUsed());
        }
        this.deviceAttributeList.add(attributeMap);
        this.requestMemory(memUsage);
        return this.deviceAttributeList.size() - 1;
    }

    @Override
    public Map<String, Binary> alterAttribute(int pointer, List<String> nameList, Object[] valueList, String tableName) {
        long memUsageDelta = 0L;
        HashMap<String, Binary> updateMap = new HashMap<String, Binary>();
        Map<String, Binary> attributeMap = this.deviceAttributeList.get(pointer);
        for (int i = 0; i < nameList.size(); ++i) {
            long originMemUsage;
            String key = nameList.get(i);
            Binary value = (Binary)valueList[i];
            long l = originMemUsage = attributeMap.containsKey(key) ? MemUsageUtil.computeKVMemUsageInMap((String)key, (Binary)attributeMap.get(key)) : 0L;
            if (value != null) {
                if (!Objects.equals(value, attributeMap.put(key, value))) {
                    updateMap.put(key, value);
                }
                long updatedMemUsage = MemUsageUtil.computeKVMemUsageInMap((String)key, (Binary)value);
                memUsageDelta += updatedMemUsage - originMemUsage;
                continue;
            }
            if (Objects.nonNull(attributeMap.remove(key))) {
                updateMap.put(key, Binary.EMPTY_VALUE);
            }
            memUsageDelta -= originMemUsage;
        }
        if (memUsageDelta > 0L) {
            this.requestMemory(memUsageDelta);
            this.addTableAttributeMemory(tableName, memUsageDelta);
        } else if (memUsageDelta < 0L) {
            this.releaseMemory(-memUsageDelta);
            this.decreaseTableAttributeMemory(tableName, -memUsageDelta);
        }
        return updateMap;
    }

    @Override
    public void removeAttribute(int pointer, String tableName) {
        this.releaseMemory(MAP_SIZE + UpdateDetailContainer.sizeOfMapEntries(this.deviceAttributeList.get(pointer)));
        this.decreaseTableAttributeMemory(tableName, this.deviceAttributeList.get(pointer).values().stream().map(UpdateDetailContainer::sizeOf).reduce(0L, Long::sum));
        this.deviceAttributeList.set(pointer, null);
    }

    @Override
    public void removeAttribute(int pointer, String attributeName, String tableName) {
        Map<String, Binary> attributeMap = this.deviceAttributeList.get(pointer);
        if (Objects.isNull(attributeMap)) {
            return;
        }
        Binary value = attributeMap.remove(attributeName);
        if (Objects.nonNull(value)) {
            this.releaseMemory(MemUsageUtil.computeKVMemUsageInMap((String)attributeName, (Binary)value));
            this.decreaseTableAttributeMemory(tableName, value.ramBytesUsed());
        }
    }

    @Override
    public Map<String, Binary> getAttributes(int pointer) {
        return this.deviceAttributeList.get(pointer);
    }

    @Override
    public Binary getAttributes(int pointer, String name) {
        return this.deviceAttributeList.get(pointer).get(name);
    }

    private void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.deviceAttributeList.size(), (OutputStream)outputStream);
        for (Map<String, Binary> attributeMap : this.deviceAttributeList) {
            DeviceAttributeStore.write(attributeMap, outputStream);
        }
    }

    public static int write(Map<String, Binary> map, OutputStream stream) throws IOException {
        if (map == null) {
            return ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
        }
        int length = 0;
        length += ReadWriteIOUtils.write((int)map.size(), (OutputStream)stream);
        for (Map.Entry<String, Binary> entry : map.entrySet()) {
            length += ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            length += DeviceAttributeStore.writeBinary(entry.getValue(), stream);
        }
        return length;
    }

    private static int writeBinary(Binary binary, OutputStream outputStream) throws IOException {
        return binary == Binary.EMPTY_VALUE ? ReadWriteIOUtils.write((int)-1, (OutputStream)outputStream) : ReadWriteIOUtils.write((Binary)binary, (OutputStream)outputStream);
    }

    private void deserialize(InputStream inputStream) throws IOException {
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            Map<String, Binary> attributeMap = DeviceAttributeStore.readMap(inputStream, false);
            this.deviceAttributeList.add(attributeMap);
            this.requestMemory((long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (Objects.nonNull(attributeMap) ? MAP_SIZE + UpdateDetailContainer.sizeOfMapEntries(attributeMap) : 0L));
        }
    }

    public static Map<String, Binary> readMap(InputStream inputStream, boolean concurrent) throws IOException {
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        if (length == -1) {
            return null;
        }
        ConcurrentHashMap<String, Binary> map = concurrent ? new ConcurrentHashMap(length) : new HashMap(length);
        for (int i = 0; i < length; ++i) {
            map.put(ReadWriteIOUtils.readString((InputStream)inputStream), DeviceAttributeStore.readBinary(inputStream));
        }
        return map;
    }

    private static Binary readBinary(InputStream inputStream) throws IOException {
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        if (length == -1) {
            return Binary.EMPTY_VALUE;
        }
        byte[] bytes = ReadWriteIOUtils.readBytes((InputStream)inputStream, (int)length);
        return new Binary(bytes);
    }

    private void requestMemory(long size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.requestMemory(size);
        }
    }

    private void addTableAttributeMemory(String tableName, long size) {
        if (Objects.nonNull(this.regionStatistics)) {
            this.regionStatistics.addTableAttributeMemory(tableName, size);
        }
    }

    private void releaseMemory(long size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.releaseMemory(size);
        }
    }

    private void decreaseTableAttributeMemory(String tableName, long size) {
        if (Objects.nonNull(this.regionStatistics)) {
            this.regionStatistics.decreaseTableAttributeMemory(tableName, size);
        }
    }
}

