/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging.error;

import io.netty.channel.ChannelDuplexHandler;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import reactor.netty.http.server.logging.error.ErrorLog;
import reactor.netty.http.server.logging.error.ErrorLogArgProvider;
import reactor.util.annotation.Nullable;

class BaseErrorLogHandler
extends ChannelDuplexHandler {
    static String PID;
    static final String DEFAULT_LOG_FORMAT;
    static final DateTimeFormatter DATE_TIME_FORMATTER;
    static final String MISSING = "-";
    static final Function<ErrorLogArgProvider, ErrorLog> DEFAULT_ERROR_LOG;
    final Function<ErrorLogArgProvider, ErrorLog> errorLog;

    BaseErrorLogHandler(@Nullable Function<ErrorLogArgProvider, ErrorLog> errorLog) {
        this.errorLog = errorLog == null ? DEFAULT_ERROR_LOG : errorLog;
    }

    private static String refinedRemoteAddress(@Nullable SocketAddress remoteAddress) {
        if (remoteAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)remoteAddress).getHostString();
        }
        return MISSING;
    }

    private static String refinedExceptionMessage(Throwable throwable) {
        String error = throwable.getClass().getName();
        String message = throwable.getLocalizedMessage();
        return message == null ? error : error + "." + message;
    }

    static {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        PID = index != -1 ? jvmName.substring(0, index) : jvmName;
        DEFAULT_LOG_FORMAT = "[{}] [pid " + PID + "] [client {}] {}";
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssZ");
        DEFAULT_ERROR_LOG = args -> ErrorLog.create(DEFAULT_LOG_FORMAT, args.errorDateTime().format(DATE_TIME_FORMATTER), BaseErrorLogHandler.refinedRemoteAddress(args.remoteAddress()), BaseErrorLogHandler.refinedExceptionMessage(args.cause()));
    }
}

