/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.TablePrivilege;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DatabasePrivilege {
    private String databaseName;
    private Map<String, TablePrivilege> tablePrivilegeMap;
    private Set<PrivilegeType> privilegeSet;
    private Set<PrivilegeType> grantOptionSet;

    public DatabasePrivilege(String databaseName) {
        this.databaseName = databaseName;
        this.tablePrivilegeMap = new HashMap<String, TablePrivilege>();
        this.privilegeSet = new HashSet<PrivilegeType>();
        this.grantOptionSet = new HashSet<PrivilegeType>();
    }

    public DatabasePrivilege() {
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, TablePrivilege> getTablePrivilegeMap() {
        return this.tablePrivilegeMap;
    }

    public void setPrivileges(int mask) {
        int PRI_SIZE = PrivilegeType.getPrivilegeCount(PrivilegeModelType.RELATIONAL);
        for (int i = 0; i < PRI_SIZE; ++i) {
            if ((1 << i & mask) == 0) continue;
            this.privilegeSet.add(AuthUtils.posToObjPri(i));
            if ((1 << i + 16 & mask) == 0) continue;
            this.grantOptionSet.add(AuthUtils.posToObjPri(i));
        }
    }

    public int getAllPrivileges() {
        int privilege = 0;
        for (PrivilegeType pri : this.privilegeSet) {
            privilege |= 1 << AuthUtils.objPriToPos(pri);
        }
        for (PrivilegeType pri : this.grantOptionSet) {
            privilege |= 1 << AuthUtils.objPriToPos(pri) + 16;
        }
        return privilege;
    }

    public Set<Integer> getPrivilegeSet() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType priv : this.privilegeSet) {
            res.add(priv.ordinal());
        }
        return res;
    }

    public Set<Integer> getPrivilegeGrantOptSet() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType priv : this.grantOptionSet) {
            res.add(priv.ordinal());
        }
        return res;
    }

    public void grantDBPrivilege(PrivilegeType privilegeType) {
        this.privilegeSet.add(privilegeType);
    }

    public void revokeDBPrivilege(PrivilegeType privilegeType) {
        this.privilegeSet.remove((Object)privilegeType);
        this.revokeDBGrantOption(privilegeType);
    }

    public void grantDBGrantOption(PrivilegeType privilegeType) {
        this.grantOptionSet.add(privilegeType);
    }

    public void revokeDBGrantOption(PrivilegeType privilegeType) {
        this.grantOptionSet.remove((Object)privilegeType);
    }

    public void grantTablePrivilege(String tableName, PrivilegeType privilegeType) {
        if (!this.tablePrivilegeMap.containsKey(tableName)) {
            TablePrivilege tablePrivilege = new TablePrivilege(tableName);
            tablePrivilege.grantPrivilege(privilegeType);
            this.tablePrivilegeMap.put(tableName, tablePrivilege);
        } else {
            this.tablePrivilegeMap.get(tableName).grantPrivilege(privilegeType);
        }
    }

    public void revokeTablePrivilege(String tableName, PrivilegeType privilegeType) {
        if (this.tablePrivilegeMap.containsKey(tableName)) {
            TablePrivilege tablePrivilege = this.tablePrivilegeMap.get(tableName);
            tablePrivilege.revokePrivilege(privilegeType);
            tablePrivilege.revokeGrantOption(privilegeType);
            if (tablePrivilege.getPrivileges().isEmpty()) {
                this.tablePrivilegeMap.remove(tableName);
            }
        }
    }

    public void grantTableGrantOption(String tableName, PrivilegeType privilegeType) {
        if (this.tablePrivilegeMap.containsKey(tableName)) {
            TablePrivilege tablePrivilege = this.tablePrivilegeMap.get(tableName);
            tablePrivilege.grantOption(privilegeType);
        }
    }

    public void revokeTableGrantOption(String tableName, PrivilegeType privilegeType) {
        if (this.tablePrivilegeMap.containsKey(tableName)) {
            TablePrivilege tablePrivilege = this.tablePrivilegeMap.get(tableName);
            tablePrivilege.revokeGrantOption(privilegeType);
        }
    }

    public boolean checkDBPrivilege(PrivilegeType privilegeType) {
        return this.privilegeSet.contains((Object)privilegeType);
    }

    public boolean checkTablePrivilege(String tableName, PrivilegeType privilegeType) {
        TablePrivilege privileges = this.tablePrivilegeMap.get(tableName);
        if (privileges == null) {
            return false;
        }
        return privileges.getPrivileges().contains((Object)privilegeType);
    }

    public boolean checkDBGrantOption(PrivilegeType type) {
        return this.privilegeSet.contains((Object)type) && this.grantOptionSet.contains((Object)type);
    }

    public boolean checkTableGrantOption(String tableName, PrivilegeType type) {
        TablePrivilege tablePrivilege = this.tablePrivilegeMap.get(tableName);
        if (tablePrivilege == null) {
            return false;
        }
        return tablePrivilege.getPrivileges().contains((Object)type) && tablePrivilege.getGrantOption().contains((Object)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabasePrivilege that = (DatabasePrivilege)o;
        return this.databaseName.equals(that.databaseName) && Objects.equals(this.privilegeSet, that.privilegeSet) && Objects.equals(this.grantOptionSet, that.grantOptionSet) && Objects.equals(this.tablePrivilegeMap, that.tablePrivilegeMap);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tablePrivilegeMap, this.privilegeSet, this.grantOptionSet);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Database(").append(this.databaseName).append("):{");
        ArrayList<PrivilegeType> list = new ArrayList<PrivilegeType>(this.privilegeSet);
        Collections.sort(list);
        for (PrivilegeType privilegeType : list) {
            builder.append((Object)privilegeType);
            if (this.grantOptionSet.contains((Object)privilegeType)) {
                builder.append("_with_grant_option");
            }
            builder.append(",");
        }
        builder.append("; Tables: [");
        for (Map.Entry entry : this.tablePrivilegeMap.entrySet()) {
            builder.append(" ").append(((TablePrivilege)entry.getValue()).toString());
        }
        builder.append("]}");
        return builder.toString();
    }

    public ByteBuffer serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(this.databaseName, dataOutputStream);
        SerializeUtils.serializePrivilegeTypeSet(this.privilegeSet, dataOutputStream);
        SerializeUtils.serializePrivilegeTypeSet(this.grantOptionSet, dataOutputStream);
        ReadWriteIOUtils.write((int)this.tablePrivilegeMap.size(), (OutputStream)dataOutputStream);
        for (Map.Entry<String, TablePrivilege> tablePrivilegeEntry : this.tablePrivilegeMap.entrySet()) {
            tablePrivilegeEntry.getValue().serialize(dataOutputStream);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.privilegeSet = new HashSet<PrivilegeType>();
        this.grantOptionSet = new HashSet<PrivilegeType>();
        this.tablePrivilegeMap = new HashMap<String, TablePrivilege>();
        this.databaseName = SerializeUtils.deserializeString(buffer);
        SerializeUtils.deserializePrivilegeTypeSet(this.privilegeSet, buffer);
        SerializeUtils.deserializePrivilegeTypeSet(this.grantOptionSet, buffer);
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            TablePrivilege tablePrivilege = new TablePrivilege();
            tablePrivilege.deserialize(buffer);
            this.tablePrivilegeMap.put(tablePrivilege.getTableName(), tablePrivilege);
        }
    }
}

