/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;

public class PathPrivilege {
    private PartialPath path;
    private Set<PrivilegeType> privileges;
    private Set<PrivilegeType> grantOpts;
    private static final int PRI_SIZE = PrivilegeType.getPrivilegeCount(PrivilegeModelType.TREE);

    public PathPrivilege() {
    }

    public PathPrivilege(PartialPath path) {
        this.path = path;
        this.privileges = new HashSet<PrivilegeType>();
        this.grantOpts = new HashSet<PrivilegeType>();
    }

    public void setPrivileges(Set<PrivilegeType> privs) {
        this.privileges = privs;
    }

    public void setPrivilegesInt(Set<Integer> privs) {
        this.privileges = new HashSet<PrivilegeType>();
        for (Integer priv : privs) {
            this.privileges.add(PrivilegeType.values()[priv]);
        }
    }

    public void setGrantOpt(Set<PrivilegeType> grantOpts) {
        this.grantOpts = grantOpts;
    }

    public void setGrantOptInt(Set<Integer> grantOpts) {
        this.grantOpts = new HashSet<PrivilegeType>();
        for (Integer priv : grantOpts) {
            this.grantOpts.add(PrivilegeType.values()[priv]);
        }
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public void setAllPrivileges(int privs) {
        for (int i = 0; i < PRI_SIZE; ++i) {
            if ((1 << i & privs) != 0) {
                this.privileges.add(PrivilegeType.values()[AuthUtils.pathPosToPri(i)]);
            }
            if ((1 << i + 16 & privs) == 0) continue;
            this.grantOpts.add(PrivilegeType.values()[AuthUtils.pathPosToPri(i)]);
        }
    }

    public void grantPrivilege(PrivilegeType privilege, boolean grantOpt) {
        this.privileges.add(privilege);
        if (grantOpt) {
            this.grantOpts.add(privilege);
        }
    }

    public boolean revokePrivilege(PrivilegeType privilege) {
        if (!this.privileges.contains((Object)privilege)) {
            return false;
        }
        this.privileges.remove((Object)privilege);
        this.grantOpts.remove((Object)privilege);
        return true;
    }

    public boolean revokeGrantOpt(PrivilegeType privilege) {
        if (!this.privileges.contains((Object)privilege)) {
            return false;
        }
        this.grantOpts.remove((Object)privilege);
        return true;
    }

    public Set<PrivilegeType> getGrantOpt() {
        return this.grantOpts;
    }

    public Set<Integer> getGrantOptIntSet() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType item : this.grantOpts) {
            res.add(item.ordinal());
        }
        return res;
    }

    public Set<Integer> getPrivilegeIntSet() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType item : this.privileges) {
            res.add(item.ordinal());
        }
        return res;
    }

    public Set<PrivilegeType> getPrivileges() {
        return this.privileges;
    }

    public boolean checkPrivilege(PrivilegeType privilege) {
        if (this.privileges.contains((Object)privilege)) {
            return true;
        }
        if (privilege == PrivilegeType.READ_DATA) {
            return this.privileges.contains((Object)PrivilegeType.WRITE_DATA);
        }
        if (privilege == PrivilegeType.READ_SCHEMA) {
            return this.privileges.contains((Object)PrivilegeType.WRITE_SCHEMA);
        }
        return false;
    }

    public int getAllPrivileges() {
        int privilege = 0;
        for (PrivilegeType pri : this.privileges) {
            privilege |= 1 << AuthUtils.pathPriToPos(pri);
        }
        for (PrivilegeType grantOpt : this.grantOpts) {
            privilege |= 1 << AuthUtils.pathPriToPos(grantOpt) + 16;
        }
        return privilege;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPrivilege that = (PathPrivilege)o;
        return Objects.equals(this.privileges, that.privileges) && Objects.equals(this.path, that.path) && Objects.equals(this.grantOpts, that.grantOpts);
    }

    public int hashCode() {
        return Objects.hash(this.privileges, this.grantOpts, this.path);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.path.getFullPath());
        builder.append(" :");
        ArrayList<PrivilegeType> sortedPrivileges = new ArrayList<PrivilegeType>(this.privileges);
        Collections.sort(sortedPrivileges);
        for (PrivilegeType privilege : sortedPrivileges) {
            builder.append(" ").append((Object)privilege);
            if (!this.grantOpts.contains((Object)privilege)) continue;
            builder.append("_").append("with_grant_option");
        }
        return builder.toString();
    }

    public ByteBuffer serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serializePrivilegeTypeSet(this.privileges, dataOutputStream);
        SerializeUtils.serializePrivilegeTypeSet(this.grantOpts, dataOutputStream);
        this.path.serialize(dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.privileges = new HashSet<PrivilegeType>();
        SerializeUtils.deserializePrivilegeTypeSet(this.privileges, buffer);
        this.grantOpts = new HashSet<PrivilegeType>();
        SerializeUtils.deserializePrivilegeTypeSet(this.grantOpts, buffer);
        this.path = (PartialPath)PathDeserializeUtil.deserialize(buffer);
    }
}

