/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import org.apache.iotdb.library.drepair.util.ValueFill;
import org.apache.iotdb.udf.api.access.RowIterator;

public class LinearFill
extends ValueFill {
    private int prevNotNaN = -1;

    public LinearFill(RowIterator dataIterator) throws Exception {
        super(dataIterator);
    }

    @Override
    public void fill() {
        for (int i = 0; i < this.original.length; ++i) {
            if (Double.isNaN(this.original[i])) continue;
            double k = 0.0;
            if (this.prevNotNaN > 0) {
                k = this.original[i] - this.original[this.prevNotNaN];
                k /= (double)(i - this.prevNotNaN);
            }
            for (int t2 = this.prevNotNaN + 1; t2 < i; ++t2) {
                this.repaired[t2] = this.original[i] + k * (double)(t2 - i);
            }
            this.repaired[i] = this.original[i];
            this.prevNotNaN = i;
        }
        if (this.prevNotNaN < this.original.length - 1 && this.prevNotNaN >= 0) {
            for (int t3 = this.prevNotNaN; t3 <= this.original.length - 1; ++t3) {
                this.repaired[t3] = this.original[this.prevNotNaN];
            }
        }
    }
}

