/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.List;
import java.util.Objects;

public class CreateModel extends Statement {

  private final String modelId;
  private final String uri;

  public CreateModel(String modelId, String uri) {
    super(null);
    this.modelId = modelId;
    this.uri = uri;
  }

  public String getModelId() {
    return modelId;
  }

  public String getUri() {
    return uri;
  }

  @Override
  public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
    return visitor.visitCreateModel(this, context);
  }

  @Override
  public List<? extends Node> getChildren() {
    return null;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateModel that = (CreateModel) o;
    return Objects.equals(modelId, that.modelId) && Objects.equals(uri, that.uri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(modelId, uri);
  }

  @Override
  public String toString() {
    return "CreateModel{" + "modelId='" + modelId + '\'' + ", uri='" + uri + '\'' + '}';
  }
}
