/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table.view;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.column.FieldColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.confignode.persistence.schema.TreeDeviceViewFieldDetector;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AddTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;

public class AddViewColumnProcedure
extends AddTableColumnProcedure {
    public AddViewColumnProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public AddViewColumnProcedure(String database, String tableName, String queryId, List<TsTableColumnSchema> addedColumnList, boolean isGeneratedByPipe) {
        super(database, tableName, queryId, addedColumnList, isGeneratedByPipe);
    }

    @Override
    protected void columnCheck(ConfigNodeProcedureEnv env) {
        TSStatus status;
        super.columnCheck(env);
        if (this.getState().equals((Object)ProcedureState.FAILED)) {
            return;
        }
        HashMap<String, Set<FieldColumnSchema>> fields2Detect = new HashMap<String, Set<FieldColumnSchema>>();
        for (TsTableColumnSchema schema : this.addedColumnList) {
            if (!(schema instanceof FieldColumnSchema) || schema.getDataType() != TSDataType.UNKNOWN) continue;
            String key = TreeViewSchema.getSourceName((TsTableColumnSchema)schema);
            if (!fields2Detect.containsKey(key)) {
                fields2Detect.put(key, new HashSet());
            }
            ((Set)fields2Detect.get(key)).add((FieldColumnSchema)schema);
        }
        if (!fields2Detect.isEmpty() && (status = new TreeDeviceViewFieldDetector(env.getConfigManager(), this.table, fields2Detect).detectMissingFieldTypes()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    @Override
    protected String getActionMessage() {
        return "add view column";
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_ADD_VIEW_COLUMN_PROCEDURE.getTypeCode() : ProcedureType.ADD_VIEW_COLUMN_PROCEDURE.getTypeCode());
        this.innerSerialize(stream);
    }
}

