/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.mailet.MailetConfig;

public class MailetUtil {
    public static Optional<Boolean> getInitParameter(MailetConfig config, String name) {
        String value = config.getInitParameter(name);
        if ("true".equalsIgnoreCase(value)) {
            return Optional.of(true);
        }
        if ("false".equalsIgnoreCase(value)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition, int defaultValue) throws MessagingException {
        String defaultStringValue = String.valueOf(defaultValue);
        return MailetUtil.getInitParameterAsStrictlyPositiveInteger(condition, Optional.of(defaultStringValue));
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition) throws MessagingException {
        return MailetUtil.getInitParameterAsStrictlyPositiveInteger(condition, Optional.empty());
    }

    private static int getInitParameterAsStrictlyPositiveInteger(String condition, Optional<String> defaultValue) throws MessagingException {
        String value = Optional.ofNullable(condition).orElse(defaultValue.orElse(null));
        if (Strings.isNullOrEmpty((String)value)) {
            throw new MessagingException("Condition is required. It should be a strictly positive integer");
        }
        int valueAsInt = MailetUtil.tryParseInteger(value);
        if (valueAsInt < 1) {
            throw new MessagingException("Expecting condition to be a strictly positive integer. Got " + value);
        }
        return valueAsInt;
    }

    private static int tryParseInteger(String value) throws MessagingException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Expecting condition to be a strictly positive integer. Got " + value);
        }
    }
}

