/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEventDeadLettersDAO {
    private final CassandraAsyncExecutor executor;
    private final EventSerializer eventSerializer;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectEventStatement;
    private final PreparedStatement selectEventIdsWithGroupStatement;
    private final PreparedStatement containEventsStatement;

    @Inject
    CassandraEventDeadLettersDAO(Session session, EventSerializer eventSerializer) {
        this.executor = new CassandraAsyncExecutor(session);
        this.eventSerializer = eventSerializer;
        this.insertStatement = this.prepareInsertStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
        this.selectEventStatement = this.prepareSelectEventStatement(session);
        this.selectEventIdsWithGroupStatement = this.prepareSelectInsertionIdsWithGroupStatement(session);
        this.containEventsStatement = this.prepareContainEventStatement(session);
    }

    private PreparedStatement prepareInsertStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"event_dead_letters").value("group", (Object)QueryBuilder.bindMarker((String)"group")).value("insertionId", (Object)QueryBuilder.bindMarker((String)"insertionId")).value("event", (Object)QueryBuilder.bindMarker((String)"event")));
    }

    private PreparedStatement prepareDeleteStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("event_dead_letters").where(QueryBuilder.eq((String)"group", (Object)QueryBuilder.bindMarker((String)"group"))).and(QueryBuilder.eq((String)"insertionId", (Object)QueryBuilder.bindMarker((String)"insertionId"))));
    }

    private PreparedStatement prepareSelectEventStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"event"}).from("event_dead_letters").where(QueryBuilder.eq((String)"group", (Object)QueryBuilder.bindMarker((String)"group"))).and(QueryBuilder.eq((String)"insertionId", (Object)QueryBuilder.bindMarker((String)"insertionId"))));
    }

    private PreparedStatement prepareSelectInsertionIdsWithGroupStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"insertionId"}).from("event_dead_letters").where(QueryBuilder.eq((String)"group", (Object)QueryBuilder.bindMarker((String)"group"))));
    }

    private PreparedStatement prepareContainEventStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"event"}).from("event_dead_letters").limit(1));
    }

    Mono<Void> store(Group group, Event failedEvent, EventDeadLetters.InsertionId insertionId) {
        return this.executor.executeVoid((Statement)this.insertStatement.bind().setString("group", group.asString()).setUUID("insertionId", insertionId.getId()).setString("event", this.eventSerializer.toJson(failedEvent)));
    }

    Mono<Void> removeEvent(Group group, EventDeadLetters.InsertionId failedInsertionId) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind().setString("group", group.asString()).setUUID("insertionId", failedInsertionId.getId()));
    }

    Mono<Event> retrieveFailedEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return this.executor.executeSingleRow((Statement)this.selectEventStatement.bind().setString("group", group.asString()).setUUID("insertionId", insertionId.getId())).map(row -> this.deserializeEvent(row.getString("event")));
    }

    Flux<EventDeadLetters.InsertionId> retrieveInsertionIdsWithGroup(Group group) {
        return this.executor.executeRows((Statement)this.selectEventIdsWithGroupStatement.bind().setString("group", group.asString())).map(row -> EventDeadLetters.InsertionId.of((UUID)row.getUUID("insertionId")));
    }

    Mono<Boolean> containEvents() {
        return this.executor.executeReturnExists((Statement)this.containEventsStatement.bind());
    }

    private Event deserializeEvent(String serializedEvent) {
        return this.eventSerializer.asEvent(serializedEvent);
    }
}

