/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class PluginStats
implements JsonpSerializable {
    private final String classname;
    private final String description;
    private final String opensearchVersion;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    private final String javaVersion;
    private final String name;
    private final String version;
    private final boolean licensed;
    private final String type;
    public static final JsonpDeserializer<PluginStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PluginStats::setupPluginStatsDeserializer);

    private PluginStats(Builder builder) {
        this.classname = ApiTypeHelper.requireNonNull(builder.classname, this, "classname");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.opensearchVersion = ApiTypeHelper.requireNonNull(builder.opensearchVersion, this, "opensearchVersion");
        this.extendedPlugins = ApiTypeHelper.unmodifiableRequired(builder.extendedPlugins, (Object)this, "extendedPlugins");
        this.hasNativeController = ApiTypeHelper.requireNonNull(builder.hasNativeController, this, "hasNativeController");
        this.javaVersion = ApiTypeHelper.requireNonNull(builder.javaVersion, this, "javaVersion");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.licensed = ApiTypeHelper.requireNonNull(builder.licensed, this, "licensed");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static PluginStats of(Function<Builder, ObjectBuilder<PluginStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String classname() {
        return this.classname;
    }

    public final String description() {
        return this.description;
    }

    public String opensearchVersion() {
        return this.opensearchVersion;
    }

    public final List<String> extendedPlugins() {
        return this.extendedPlugins;
    }

    public final boolean hasNativeController() {
        return this.hasNativeController;
    }

    public final String javaVersion() {
        return this.javaVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final boolean licensed() {
        return this.licensed;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("classname");
        generator.write(this.classname);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("opensearch_version");
        generator.write(this.opensearchVersion);
        if (ApiTypeHelper.isDefined(this.extendedPlugins)) {
            generator.writeKey("extended_plugins");
            generator.writeStartArray();
            for (String item0 : this.extendedPlugins) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("has_native_controller");
        generator.write(this.hasNativeController);
        generator.writeKey("java_version");
        generator.write(this.javaVersion);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("licensed");
        generator.write(this.licensed);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupPluginStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classname, JsonpDeserializer.stringDeserializer(), "classname");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::opensearchVersion, JsonpDeserializer.stringDeserializer(), "opensearch_version");
        op.add(Builder::extendedPlugins, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extended_plugins");
        op.add(Builder::hasNativeController, JsonpDeserializer.booleanDeserializer(), "has_native_controller");
        op.add(Builder::javaVersion, JsonpDeserializer.stringDeserializer(), "java_version");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::licensed, JsonpDeserializer.booleanDeserializer(), "licensed");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PluginStats> {
        private String classname;
        private String description;
        private String opensearchVersion;
        private List<String> extendedPlugins;
        private Boolean hasNativeController;
        private String javaVersion;
        private String name;
        private String version;
        private Boolean licensed;
        private String type;

        public final Builder classname(String value) {
            this.classname = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder opensearchVersion(String value) {
            this.opensearchVersion = value;
            return this;
        }

        public final Builder extendedPlugins(List<String> list) {
            this.extendedPlugins = Builder._listAddAll(this.extendedPlugins, list);
            return this;
        }

        public final Builder extendedPlugins(String value, String ... values) {
            this.extendedPlugins = Builder._listAdd(this.extendedPlugins, value, values);
            return this;
        }

        public final Builder hasNativeController(boolean value) {
            this.hasNativeController = value;
            return this;
        }

        public final Builder javaVersion(String value) {
            this.javaVersion = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder licensed(boolean value) {
            this.licensed = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public PluginStats build() {
            this._checkSingleUse();
            return new PluginStats(this);
        }
    }
}

