/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeRole;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeAttributes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeAttributes> {
    @Nonnull
    private final Map<String, String> attributes;
    @Nonnull
    private final String ephemeralId;
    @Nullable
    private final String externalId;
    @Nullable
    private final String id;
    @Nonnull
    private final String name;
    @Nonnull
    private final List<NodeRole> roles;
    @Nonnull
    private final String transportAddress;
    public static final JsonpDeserializer<NodeAttributes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAttributes::setupNodeAttributesDeserializer);

    private NodeAttributes(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.ephemeralId = ApiTypeHelper.requireNonNull(builder.ephemeralId, this, "ephemeralId");
        this.externalId = builder.externalId;
        this.id = builder.id;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
    }

    public static NodeAttributes of(Function<Builder, ObjectBuilder<NodeAttributes>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nonnull
    public final String ephemeralId() {
        return this.ephemeralId;
    }

    @Nullable
    public final String externalId() {
        return this.externalId;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nonnull
    public final String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("ephemeral_id");
        generator.write(this.ephemeralId);
        if (this.externalId != null) {
            generator.writeKey("external_id");
            generator.write(this.externalId);
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeAttributesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id");
        op.add(Builder::externalId, JsonpDeserializer.stringDeserializer(), "external_id");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.ephemeralId.hashCode();
        result = 31 * result + Objects.hashCode(this.externalId);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.roles);
        result = 31 * result + this.transportAddress.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeAttributes other = (NodeAttributes)o;
        return this.attributes.equals(other.attributes) && this.ephemeralId.equals(other.ephemeralId) && Objects.equals(this.externalId, other.externalId) && Objects.equals(this.id, other.id) && this.name.equals(other.name) && Objects.equals(this.roles, other.roles) && this.transportAddress.equals(other.transportAddress);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeAttributes> {
        private Map<String, String> attributes;
        private String ephemeralId;
        @Nullable
        private String externalId;
        @Nullable
        private String id;
        private String name;
        @Nullable
        private List<NodeRole> roles;
        private String transportAddress;

        public Builder() {
        }

        private Builder(NodeAttributes o) {
            this.attributes = Builder._mapCopy(o.attributes);
            this.ephemeralId = o.ephemeralId;
            this.externalId = o.externalId;
            this.id = o.id;
            this.name = o.name;
            this.roles = Builder._listCopy(o.roles);
            this.transportAddress = o.transportAddress;
        }

        private Builder(Builder o) {
            this.attributes = Builder._mapCopy(o.attributes);
            this.ephemeralId = o.ephemeralId;
            this.externalId = o.externalId;
            this.id = o.id;
            this.name = o.name;
            this.roles = Builder._listCopy(o.roles);
            this.transportAddress = o.transportAddress;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        @Nonnull
        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder ephemeralId(String value) {
            this.ephemeralId = value;
            return this;
        }

        @Nonnull
        public final Builder externalId(@Nullable String value) {
            this.externalId = value;
            return this;
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        @Nonnull
        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        @Nonnull
        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeAttributes build() {
            this._checkSingleUse();
            return new NodeAttributes(this);
        }
    }
}

