/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAsyncExecutor {
    private final CqlSession session;

    public static String asString(Statement statement) {
        if (statement instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement;
            return boundStatement.getPreparedStatement().getQuery();
        }
        if (statement instanceof SimpleStatement) {
            SimpleStatement simpleStatement = (SimpleStatement)statement;
            return simpleStatement.getQuery();
        }
        return statement.toString();
    }

    @Inject
    public CassandraAsyncExecutor(CqlSession session) {
        this.session = session;
    }

    private ReactiveResultSet execute(Statement statement) {
        return this.session.executeReactive(statement);
    }

    public Mono<Boolean> executeReturnApplied(Statement statement) {
        return Mono.defer(() -> Mono.from((Publisher)this.execute(statement))).map(ReactiveRow::wasApplied).onErrorMap(this.withStatement(statement));
    }

    private Function<Throwable, Throwable> withStatement(Statement statement) {
        return e -> new CassandraAsyncExecutorException(statement, (Throwable)e);
    }

    public Mono<Void> executeVoid(Statement statement) {
        return Mono.defer(() -> Mono.from((Publisher)this.execute(statement))).then().onErrorMap(this.withStatement(statement));
    }

    public Mono<Row> executeSingleRow(Statement statement) {
        Mono result = Mono.defer(() -> Mono.from((Publisher)this.execute(statement)));
        return result.onErrorMap(this.withStatement(statement));
    }

    public Flux<Row> executeRows(Statement statement) {
        Flux result = Flux.defer(() -> Flux.from((Publisher)this.execute(statement)));
        return result.onErrorMap(this.withStatement(statement));
    }

    public Mono<Optional<Row>> executeSingleRowOptional(Statement statement) {
        return this.executeSingleRow(statement).map(Optional::ofNullable).switchIfEmpty(Mono.just(Optional.empty()));
    }

    public Mono<Boolean> executeReturnExists(Statement statement) {
        return this.executeSingleRow(statement).hasElement();
    }

    public class CassandraAsyncExecutorException
    extends RuntimeException {
        public CassandraAsyncExecutorException(Statement statement, Throwable e) {
            super("Failed executing " + CassandraAsyncExecutor.asString(statement), e);
        }
    }
}

