/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.james.jwt.PublicKeyReader;

public class JwtConfiguration {
    private final List<String> jwtPublicKeyPem;

    public JwtConfiguration(List<String> jwtPublicKeyPem) {
        Preconditions.checkState((boolean)this.validPublicKey(jwtPublicKeyPem), (Object)"One of the provided public key is not valid");
        this.jwtPublicKeyPem = jwtPublicKeyPem;
    }

    private boolean validPublicKey(List<String> jwtPublicKeyPem) {
        PublicKeyReader reader = new PublicKeyReader();
        return jwtPublicKeyPem.stream().allMatch(value -> reader.fromPEM((String)value).isPresent());
    }

    public List<String> getJwtPublicKeyPem() {
        return this.jwtPublicKeyPem;
    }
}

