/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;

@ChannelHandler.Sharable
public class LineHandlerUpstreamHandler<S extends ProtocolSession>
extends ChannelInboundHandlerAdapter {
    private final LineHandler<S> handler;
    private final S session;

    public LineHandlerUpstreamHandler(S session, LineHandler<S> handler) {
        this.handler = handler;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        try {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(0, bytes);
            Response response = this.handler.onLine(this.session, bytes);
            if (response != null) {
                ((ProtocolSessionImpl)this.session).getProtocolTransport().writeResponse(response, this.session);
            }
        }
        finally {
            buf.release();
        }
    }
}

