/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.dboe.base.file.ChannelManager;
import org.apache.jena.dboe.base.file.FileException;

public class FileLib {
    public static FileChannel openUnmanaged(String filename) {
        return FileLib.openUnmanaged(filename, "rw");
    }

    public static FileChannel openUnmanaged(String filename, String mode) {
        try {
            RandomAccessFile out = new RandomAccessFile(filename, mode);
            FileChannel channel = out.getChannel();
            return channel;
        }
        catch (FileNotFoundException e) {
            IO.exception((IOException)e);
            return null;
        }
    }

    public static FileChannel openManaged(String filename) {
        return FileLib.openManaged(filename, "rw");
    }

    public static FileChannel openManaged(String filename, String mode) {
        return ChannelManager.acquire(filename, mode);
    }

    public static long size(FileChannel channel) {
        try {
            return channel.size();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return -1L;
        }
    }

    public static void truncate(FileChannel channel, long posn) {
        try {
            channel.truncate(posn);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    public static void close(FileChannel channel) {
        ChannelManager.release(channel);
    }

    public static void sync(FileChannel channel) {
        try {
            channel.force(true);
        }
        catch (IOException ex) {
            throw new FileException("FileBase.sync", ex);
        }
    }
}

