/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.jena.atlas.lib.ByteBufferLib;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.page.Page;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreeNodeMgr;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;

class BPlusTreeTools {
    BPlusTreeTools() {
    }

    private static void binDump(String filename) {
        try (RandomAccessFile fh = new RandomAccessFile(filename, "r");){
            int x;
            ByteBuffer bb = ByteBuffer.allocate(8192);
            FileChannel ch = fh.getChannel();
            boolean idx = false;
            while ((x = ch.read(bb)) >= 0) {
                ByteBufferLib.print((ByteBuffer)bb);
                bb.clear();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void bpt_scan_record_buffer(RecordBufferPageMgr recordPageMgr, boolean verbose) {
        System.out.print("[Scan Records] start\n");
        int idx = 0;
        int n = 0;
        int total = 0;
        if (verbose) {
            System.out.printf("recordPageMgr = %s\n", recordPageMgr);
        }
        try {
            while (idx >= 0) {
                if (verbose) {
                    System.out.printf("idx = %d\n", idx);
                }
                RecordBufferPage page = (RecordBufferPage)recordPageMgr.getRead(idx);
                if (verbose) {
                    System.out.printf("%04d :: id=%04d -> link=%04d [count=%d, max=%d]\n", n, page.getId(), page.getLink(), page.getCount(), page.getMaxSize());
                }
                RecordBuffer rb = page.getRecordBuffer();
                if (verbose) {
                    System.out.printf("     :: %d %d\n", rb.getSize(), rb.maxSize());
                }
                total += rb.size();
                idx = page.getLink();
                ++n;
                recordPageMgr.release((Page)page);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + String.valueOf(ex));
        }
        System.out.printf("[Scan Records] Count = %d in %d blocks (avg: %.2f)\n", total, n, Float.valueOf((float)total / (float)n));
    }

    private static void bpt_scan_nodes(BPlusTree bpt, boolean verbose) {
        System.out.print("[Scan Nodes] start\n");
        BPTreeNodeMgr nodeMgr = new BPTreeNodeMgr(bpt, bpt.getNodeManager().getBlockMgr());
        int idx = 0;
        int n = 0;
        int total = 0;
        if (verbose) {
            System.out.printf("BPTreeNodeMgr = %s\n", new Object[]{nodeMgr});
        }
        try {
            while (idx >= 0) {
                BPTreeNode node;
                if (verbose) {
                    System.out.printf("idx = %d\n", idx);
                }
                if ((node = nodeMgr.getRead(idx, 0)) != null) {
                    System.out.println(node);
                    ++n;
                    ++idx;
                    nodeMgr.release(node);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + String.valueOf(ex));
            ex.printStackTrace();
        }
        System.out.printf("[Scan Nodes] Count = %d in %d blocks (avg: %.2f)\n", total, n, Float.valueOf((float)total / (float)n));
    }
}

