/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import org.apache.jena.mem.GraphMem;
import org.apache.jena.mem.IndexingStrategy;
import org.apache.jena.mem.store.TripleStore;
import org.apache.jena.mem.store.roaring.RoaringTripleStore;

public class GraphMemRoaring
extends GraphMem {
    public GraphMemRoaring() {
        this(IndexingStrategy.EAGER);
    }

    public GraphMemRoaring(IndexingStrategy indexingStrategy) {
        super(new RoaringTripleStore(indexingStrategy));
    }

    private GraphMemRoaring(TripleStore tripleStore) {
        super(tripleStore);
    }

    @Override
    public GraphMemRoaring copy() {
        return new GraphMemRoaring(this.tripleStore.copy());
    }

    private RoaringTripleStore getRoaringTripleStore() {
        return (RoaringTripleStore)this.tripleStore;
    }

    public IndexingStrategy getIndexingStrategy() {
        return this.getRoaringTripleStore().getIndexingStrategy();
    }

    public void clearIndex() {
        this.getRoaringTripleStore().clearIndex();
    }

    public void initializeIndex() {
        this.getRoaringTripleStore().initializeIndex();
    }

    public void initializeIndexParallel() {
        this.getRoaringTripleStore().initializeIndexParallel();
    }

    public boolean isIndexInitialized() {
        return this.getRoaringTripleStore().isIndexInitialized();
    }
}

