/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.arp1;

import java.lang.reflect.Field;
import org.apache.jena.rdfxml.arp1.ARPErrorNumbers;
import org.apache.jena.rdfxml.arp1.impl.ARPLocation;
import org.xml.sax.SAXParseException;

public class ParseException
extends SAXParseException
implements ARPErrorNumbers {
    private static final long serialVersionUID = -5986976549492477885L;
    final int id;
    private final String inputName;
    private boolean promoteMe;

    public ParseException(int id, ARPLocation where, String msg) {
        this(id, where.inputName, where.endLine, where.endColumn, msg);
    }

    public ParseException(int id, ARPLocation where, Exception e2) {
        this(id, where.inputName, where.endLine, where.endColumn, e2);
    }

    protected ParseException(int id, String inputName, int endLine, int endColumn, String msg) {
        super(msg, null, null, endLine, endColumn);
        this.id = id;
        this.inputName = inputName;
    }

    protected ParseException(int id, String inputName, int endLine, int endColumn, Exception e2) {
        super(e2.getMessage(), null, null, endLine, endColumn, e2);
        this.id = id;
        this.inputName = inputName;
    }

    public int getErrorNumber() {
        return this.id;
    }

    public boolean isSyntaxError() {
        switch (this.id) {
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: {
                return true;
            }
        }
        return false;
    }

    private SAXParseException rootCause() {
        Exception e2 = this.getException();
        return e2 == null ? this : (SAXParseException)e2;
    }

    public void promote() {
        this.promoteMe = true;
    }

    @Override
    public String getMessage() {
        String idStr = this.id != 0 ? "{" + (this.id < 200 ? "W" : "E") + ("" + (1000 + this.id)).substring(1) + "} " : "";
        return idStr + super.getMessage();
    }

    public static String formatMessage(Exception e2) {
        String msg = e2.getMessage();
        if (msg == null) {
            msg = e2.toString();
        }
        if (!(e2 instanceof SAXParseException)) {
            return msg;
        }
        SAXParseException sax = (SAXParseException)e2;
        if (sax.getLineNumber() == -1) {
            return msg;
        }
        if (sax.getColumnNumber() == -1) {
            return "(line " + sax.getLineNumber() + "): " + msg;
        }
        return "(line " + sax.getLineNumber() + " column " + sax.getColumnNumber() + "): " + msg;
    }

    public boolean isPromoted() {
        return this.promoteMe;
    }

    public static String errorCodeName(int errNo) {
        Field[] flds;
        Class<ARPErrorNumbers> c = ARPErrorNumbers.class;
        for (Field fld : flds = c.getDeclaredFields()) {
            try {
                if (fld.getInt(null) != errNo) continue;
                return fld.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int errorCode(String upper) {
        Class<ARPErrorNumbers> c = ARPErrorNumbers.class;
        try {
            Field fld = c.getField(upper);
            return fld.getInt(null);
        }
        catch (Exception e2) {
            return -1;
        }
    }
}

