/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Supplier;
import org.apache.juneau.http.entity.ByteArrayEntity;
import org.apache.juneau.http.entity.FileEntity;
import org.apache.juneau.http.entity.ReaderEntity;
import org.apache.juneau.http.entity.SerializedEntity;
import org.apache.juneau.http.entity.StreamEntity;
import org.apache.juneau.http.entity.StringEntity;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.Serializer;

public class HttpEntities {
    public static final ByteArrayEntity byteArrayEntity(byte[] content) {
        return new ByteArrayEntity().setContent(content);
    }

    public static final ByteArrayEntity byteArrayEntity(byte[] content, ContentType contentType) {
        return new ByteArrayEntity().setContent(content).setContentType(contentType);
    }

    public static final ByteArrayEntity byteArrayEntity(Supplier<byte[]> content) {
        return new ByteArrayEntity().setContent((Supplier)content);
    }

    public static final ByteArrayEntity byteArrayEntity(Supplier<byte[]> content, ContentType contentType) {
        return ((ByteArrayEntity)new ByteArrayEntity().setContent((Supplier)content)).setContentType(contentType);
    }

    public static final FileEntity fileEntity(File content) {
        return new FileEntity().setContent(content);
    }

    public static final FileEntity fileEntity(File content, ContentType contentType) {
        return new FileEntity().setContent(content).setContentType(contentType);
    }

    public static final ReaderEntity readerEntity(Reader content) {
        return new ReaderEntity().setContent(content);
    }

    public static final ReaderEntity readerEntity(Reader content, ContentType contentType) {
        return new ReaderEntity().setContent(content).setContentType(contentType);
    }

    public static final SerializedEntity serializedEntity(Object content, Serializer serializer) {
        return new SerializedEntity().setContent(content).setSerializer(serializer);
    }

    public static final SerializedEntity serializedEntity(Object content, Serializer serializer, HttpPartSchema schema) {
        return new SerializedEntity().setContent(content).setSerializer(serializer).setSchema(schema);
    }

    public static final SerializedEntity serializedEntity(Supplier<?> content, Serializer serializer) {
        return ((SerializedEntity)new SerializedEntity().setContent((Supplier)content)).setSerializer(serializer);
    }

    public static final SerializedEntity serializedEntity(Supplier<?> content, Serializer serializer, HttpPartSchema schema) {
        return ((SerializedEntity)new SerializedEntity().setContent((Supplier)content)).setSerializer(serializer).setSchema(schema);
    }

    public static final StreamEntity streamEntity(InputStream content) {
        return new StreamEntity().setContent(content);
    }

    public static final StreamEntity streamEntity(InputStream content, long length, ContentType contentType) {
        return new StreamEntity().setContent(content).setContentLength(length).setContentType(contentType);
    }

    public static final StringEntity stringEntity(String content) {
        return new StringEntity().setContent(content);
    }

    public static final StringEntity stringEntity(String content, ContentType contentType) {
        return new StringEntity().setContent(content).setContentType(contentType);
    }

    public static final StringEntity stringEntity(Supplier<String> content) {
        return new StringEntity().setContent((Supplier)content);
    }

    public static final StringEntity stringEntity(Supplier<String> content, ContentType contentType) {
        return ((StringEntity)new StringEntity().setContent((Supplier)content)).setContentType(contentType);
    }
}

